/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.CurrentJobCancellationException;
import com.intellij.openapi.progress.JobCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return Cancellation.contextJob(ThreadContext.currentThreadContext());
    }

    @Nullable
    public static Job contextJob(@NotNull CoroutineContext context) {
        return (Job)context.get((CoroutineContext.Key)Job.Key);
    }

    public static boolean isCancelled() {
        Job job = Cancellation.currentJob();
        return job != null && job.isCancelled();
    }

    public static void checkCancelled() {
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive((Job)currentJob);
            }
            catch (CancellationException e) {
                throw new JobCanceledException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Throwable> T withCurrentJob(@NotNull Job job, @NotNull ThrowableComputable<T, E> action) throws E, CancellationException {
        try (AccessToken ignored = ThreadContext.withThreadContext((CoroutineContext)job);){
            Object object = action.compute();
            return (T)object;
        }
        catch (JobCanceledException e) {
            if (job.isCancelled()) throw new CurrentJobCancellationException(e);
            throw new IllegalStateException("JobCanceledException must be thrown by ProgressManager.checkCanceled()", e);
        }
    }

    @Nullable
    public static Throwable getCause(@NotNull CancellationException ce) {
        if (ce instanceof CurrentJobCancellationException) {
            return ((CurrentJobCancellationException)ce).getOriginalCancellationException().getCause();
        }
        return ce.getCause();
    }

    public static boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        try {
            if (Cancellation.isInNonCancelableSection()) {
                return (T)computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                Object object = computable.compute();
                return (T)object;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e);
        }
    }
}

