/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public interface Module
extends ComponentManager,
AreaInstance,
Disposable {
    public static final Module[] EMPTY_ARRAY = new Module[0];
    @NonNls
    public static final String ELEMENT_TYPE = "type";

    @Override
    @Deprecated
    @NotNull
    public MessageBus getMessageBus();

    @ApiStatus.Internal
    @Nullable
    public VirtualFile getModuleFile();

    @ApiStatus.Internal
    default public @SystemIndependent @NonNls @NotNull String getModuleFilePath() {
        return this.getModuleNioFile().toString().replace(File.separatorChar, '/');
    }

    @ApiStatus.Internal
    @NotNull
    public Path getModuleNioFile();

    @NotNull
    public Project getProject();

    @NotNull
    @NlsSafe
    public String getName();

    @Override
    public boolean isDisposed();

    public boolean isLoaded();

    @Deprecated
    public void setOption(@NotNull String var1, @Nullable String var2);

    @Deprecated
    @NonNls
    @Nullable
    public String getOptionValue(@NotNull String var1);

    @NotNull
    public GlobalSearchScope getModuleScope();

    @NotNull
    public GlobalSearchScope getModuleScope(boolean var1);

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope();

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope();

    @NotNull
    public GlobalSearchScope getModuleContentScope();

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope();

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean var1);

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope();

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope();

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean var1);

    @NotNull
    default public GlobalSearchScope getModuleProductionSourceScope() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    default public GlobalSearchScope getModuleTestSourceScope() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @ApiStatus.Internal
    @Nullable
    @NonNls
    default public String getModuleTypeName() {
        return this.getOptionValue(ELEMENT_TYPE);
    }

    @ApiStatus.Internal
    default public void setModuleType(@NotNull @NonNls String name) {
        this.setOption(ELEMENT_TYPE, name);
    }
}

