/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    private static Supplier<? extends FileTypeRegistry> instanceGetter;

    @ApiStatus.Internal
    public static Supplier<? extends FileTypeRegistry> setInstanceSupplier(@NotNull Supplier<? extends FileTypeRegistry> supplier) {
        Supplier<? extends FileTypeRegistry> oldValue = instanceGetter;
        instanceGetter = supplier;
        return oldValue;
    }

    @ApiStatus.Internal
    public static boolean isInstanceSupplierSet() {
        return instanceGetter != null;
    }

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type) {
        return file2.getFileType() == type;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        return language.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        Supplier<? extends FileTypeRegistry> instanceGetter = FileTypeRegistry.instanceGetter;
        if (instanceGetter == null) {
            return (FileTypeRegistry)ApplicationManager.getApplication().getServiceByClassName("com.intellij.openapi.fileTypes.FileTypeManager");
        }
        return instanceGetter.get();
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content) {
        return this.getFileTypeByFile(file2);
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileNameSeq) {
        return this.getFileTypeByFileName(fileNameSeq.toString());
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NotNull String var1);

    public abstract FileType findFileTypeByName(@NotNull String var1);

    public static interface FileTypeDetector {
        public static final ExtensionPointName<FileTypeDetector> EP_NAME = new ExtensionPointName("com.intellij.fileTypeDetector");

        @Nullable
        public FileType detect(@NotNull VirtualFile var1, @NotNull ByteSequence var2, @Nullable CharSequence var3);

        default public int getDesiredContentPrefixLength() {
            return 1024;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        default public int getVersion() {
            return 0;
        }
    }
}

