/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.CollectionFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionProcessingHelper {
    public static <T> void forEachExtensionSafe(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<? super T> extensionConsumer) {
        for (T t : iterable) {
            if (t == null) break;
            try {
                extensionConsumer.accept(t);
            }
            catch (ProcessCanceledException | CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
    }

    @Nullable
    public static <T> T findFirstSafe(@NotNull Predicate<? super T> predicate, @NotNull Iterable<? extends T> iterable) {
        return (T)ExtensionProcessingHelper.computeSafeIfAny(o -> predicate.test(o) ? o : null, iterable);
    }

    @Nullable
    public static <T, R> R computeSafeIfAny(@NotNull Function<? super T, ? extends R> processor, @NotNull Iterable<? extends T> iterable) {
        for (T t : iterable) {
            if (t == null) {
                return null;
            }
            try {
                R result = processor.apply(t);
                if (result == null) continue;
                return result;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
        return null;
    }

    @NotNull
    public static <K, T> List<T> getByGroupingKey(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull K key, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        List result;
        Map<? extends K, List<T>> prev;
        ConcurrentMap keyMapperToCache = point.getCacheMap();
        Map<K, List<T>> cache = (Map<K, List<T>>)keyMapperToCache.get(cacheId);
        if (cache == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache = ExtensionProcessingHelper.buildCacheForGroupingKeyMapper(keyMapper, point))) != null) {
            cache = prev;
        }
        return (result = (List)cache.get(key)) == null ? Collections.emptyList() : result;
    }

    @ApiStatus.Internal
    @Nullable
    public static <K, T, V> V getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper) {
        return ExtensionProcessingHelper.doGetByKey(point, cacheId, key, keyMapper, valueMapper, point.getCacheMap());
    }

    @ApiStatus.Internal
    @Nullable
    public static <K, T> T getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        return ExtensionProcessingHelper.doGetByKey(point, cacheId, key, keyMapper, Function.identity(), point.getCacheMap());
    }

    @ApiStatus.Internal
    @NotNull
    public static <K, T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull K, ? extends @NotNull V> valueProducer) {
        ConcurrentMap cache = point.getCacheMap();
        return (V)cache.computeIfAbsent(new AbstractMap.SimpleImmutableEntry(key, cacheId), entry -> valueProducer.apply((Object)entry.getKey()));
    }

    @ApiStatus.Internal
    @NotNull
    public static <T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull @NotNull Supplier<? extends @NotNull V> valueProducer) {
        ConcurrentMap cache = point.getCacheMap();
        return (V)cache.computeIfAbsent(cacheId, __ -> valueProducer.get());
    }

    @Nullable
    private static <CACHE_KEY, K, T, V> V doGetByKey(@NotNull ExtensionPoint<T> point, @NotNull CACHE_KEY cacheId, @NotNull K key, @NotNull Function<? super T, ? extends K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper, @NotNull ConcurrentMap<CACHE_KEY, Map<K, V>> keyMapperToCache) {
        Map<? extends K, ? extends V> prev;
        Map<K, V> cache = (Map<K, V>)keyMapperToCache.get(cacheId);
        if (cache == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache = ExtensionProcessingHelper.buildCacheForKeyMapper(keyMapper, valueMapper, point))) != null) {
            cache = prev;
        }
        return cache.get(key);
    }

    @NotNull
    private static <K, T> Map<K, List<T>> buildCacheForGroupingKeyMapper(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull ExtensionPoint<T> point) {
        HashMap<Object, List> cache = new HashMap<Object, List>();
        for (T extension : point.getExtensionList()) {
            K key = keyMapper.apply(extension);
            if (key == null) continue;
            cache.computeIfAbsent(key, k -> new ArrayList()).add(extension);
        }
        return cache;
    }

    @NotNull
    private static <K, T, V> Map<K, V> buildCacheForKeyMapper(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper, @NotNull ExtensionPoint<T> point) {
        List<T> extensions = point.getExtensionList();
        Map<K, V> cache = CollectionFactory.createSmallMemoryFootprintMap(extensions.size());
        for (T extension : extensions) {
            V value;
            K key = keyMapper.apply(extension);
            if (key == null || (value = valueMapper.apply(extension)) == null) continue;
            cache.put(key, value);
        }
        return cache;
    }
}

