/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T>,
Iterable<T> {
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String name;
    private final String className;
    private volatile List<T> cachedExtensions;
    private volatile T @Nullable [] cachedExtensionsAsArray;
    private final ComponentManager componentManager;
    @NotNull
    protected final PluginDescriptor pluginDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> adapters = Collections.emptyList();
    private volatile boolean adaptersAreSorted = true;
    private ExtensionPointListener<T> @NotNull [] listeners = ExtensionPointListener.Companion.emptyArray();
    @Nullable
    private Class<T> extensionClass;
    private final boolean isDynamic;
    private final AtomicReference<ConcurrentMap<?, Map<?, ?>>> keyMapperToCacheRef = new AtomicReference();
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable Class<T> extensionClass, boolean dynamic) {
        this.name = name;
        this.className = className;
        this.pluginDescriptor = pluginDescriptor;
        this.componentManager = componentManager;
        this.extensionClass = extensionClass;
        this.isDynamic = dynamic;
    }

    @NotNull
    final <CACHE_KEY, V> ConcurrentMap<CACHE_KEY, V> getCacheMap() {
        ConcurrentMap<?, Map<?, ?>> keyMapperToCache = this.keyMapperToCacheRef.get();
        if (keyMapperToCache == null) {
            keyMapperToCache = this.keyMapperToCacheRef.updateAndGet(prev -> prev == null ? new ConcurrentHashMap() : prev);
        }
        return keyMapperToCache;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @Override
    public final boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public final void registerExtension(@NotNull T extension) {
        this.doRegisterExtension(extension, LoadingOrder.ANY, this.getPluginDescriptor(), null);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        this.registerExtension(extension, this.getPluginDescriptor(), parentDisposable);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull Disposable parentDisposable) {
        this.doRegisterExtension(extension, LoadingOrder.ANY, pluginDescriptor, parentDisposable);
    }

    @Override
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), parentDisposable);
    }

    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull PluginDescriptor pluginDescriptor, @Nullable Disposable parentDisposable) {
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.adapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).componentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, pluginDescriptor, order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(false, Collections.singletonList(adapter), this.listeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index = ContainerUtil.indexOfIdentity(this.adapters, adapter);
                    if (index < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.componentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters);
                    list.remove(index);
                    this.adapters = list;
                    this.clearCache();
                    this.notifyListeners(true, Collections.singletonList(adapter), this.listeners);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerExtensions(@NotNull List<? extends T> extensions) {
        ExtensionPointListener<T>[] listeners;
        for (ExtensionComponentAdapter adapter : this.adapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || !ContainerUtil.containsIdentity(extensions, adapter)) continue;
            LOG.error("Extension was already added: " + ((ObjectComponentAdapter)adapter).componentInstance);
            return;
        }
        List<ExtensionComponentAdapter> newAdapters = this.doRegisterExtensions(extensions);
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            listeners = this.listeners;
        }
        this.notifyListeners(false, newAdapters, listeners);
    }

    @NotNull
    private synchronized List<ExtensionComponentAdapter> doRegisterExtensions(@NotNull List<? extends T> extensions) {
        ArrayList<ExtensionComponentAdapter> newAdapters = new ArrayList<ExtensionComponentAdapter>(extensions.size());
        for (T extension : extensions) {
            newAdapters.add(new ObjectComponentAdapter(extension, this.getPluginDescriptor(), LoadingOrder.ANY));
        }
        if (this.adapters == Collections.emptyList()) {
            this.adapters = newAdapters;
        } else {
            ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters.size() + newAdapters.size());
            list.addAll(this.adapters);
            list.addAll(ExtensionPointImpl.findInsertionIndexForAnyOrder(this.adapters), newAdapters);
            this.adapters = list;
        }
        this.clearCache();
        return newAdapters;
    }

    private static int findInsertionIndexForAnyOrder(@NotNull List<? extends ExtensionComponentAdapter> adapters) {
        ExtensionComponentAdapter lastAdapter;
        int index;
        for (index = adapters.size(); index > 0 && (lastAdapter = adapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (!extensionClass.isInstance(extension)) {
            @NonNls String message = "Extension " + extension.getClass().getName() + " does not implement " + extensionClass;
            if (adapter == null) {
                throw new RuntimeException(message);
            }
            message = message + " (adapter=" + adapter + ")";
            throw this.componentManager.createError(message, null, adapter.pluginDescriptor.getPluginId(), Collections.singletonMap("threadDump", ThreadDumper.dumpThreadsToString()));
        }
    }

    @Override
    @NotNull
    public final List<T> getExtensionList() {
        List<T> result = this.cachedExtensions;
        return result == null ? this.computeExtensionList() : result;
    }

    @NotNull
    private synchronized List<T> computeExtensionList() {
        List<T> result = this.cachedExtensions;
        if (result == null) {
            T[] array = this.processAdapters();
            this.cachedExtensionsAsArray = array;
            this.cachedExtensions = result = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T @NotNull [] getExtensions() {
        T[] array = this.cachedExtensionsAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.cachedExtensionsAsArray;
                if (array == null) {
                    this.cachedExtensionsAsArray = array = this.processAdapters();
                    this.cachedExtensions = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        return array.length == 0 ? array : (Object[])array.clone();
    }

    @Override
    @ApiStatus.Experimental
    public final @NotNull Iterator<@Nullable T> iterator() {
        List<T> result = this.cachedExtensions;
        return result == null ? this.createIterator() : result.iterator();
    }

    public final void processWithPluginDescriptor(boolean shouldBeSorted, @NotNull BiConsumer<? super T, ? super PluginDescriptor> consumer) {
        if (this.isInReadOnlyMode()) {
            for (T extension : this.cachedExtensions) {
                consumer.accept(extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getSortedAdapters() : this.adapters) {
            @Nullable T extension = this.processAdapter(adapter);
            if (extension == null) continue;
            consumer.accept(extension, adapter.pluginDescriptor);
        }
    }

    public final void processImplementations(boolean shouldBeSorted, @NotNull BiConsumer<? super Supplier<? extends @Nullable T>, ? super PluginDescriptor> consumer) {
        if (this.isInReadOnlyMode()) {
            for (Object extension : this.cachedExtensions) {
                consumer.accept(() -> extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getSortedAdapters() : this.adapters) {
            consumer.accept(() -> adapter.createInstance(this.componentManager), adapter.pluginDescriptor);
        }
    }

    @TestOnly
    public final void checkImplementations(@NotNull Consumer<? super ExtensionComponentAdapter> consumer) {
        for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
            consumer.accept(adapter);
        }
    }

    public final void processIdentifiableImplementations(@NotNull @NotNull BiConsumer<? super @NotNull Supplier<? extends @Nullable T>, ? super @Nullable String> consumer) {
        for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
            Supplier<@Nullable Object> supplier = () -> adapter.createInstance(this.componentManager);
            consumer.accept(supplier, adapter.getOrderId());
        }
    }

    private @NotNull Iterator<@Nullable T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        final int size = adapters.size();
        if (size == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @Override
    public final Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    @Override
    @NotNull
    public final Stream<T> extensions() {
        List<T> result = this.cachedExtensions;
        return result == null ? StreamSupport.stream(this.spliterator(), false) : result.stream();
    }

    @Override
    public final int size() {
        List<T> cache = this.cachedExtensions;
        return cache == null ? this.adapters.size() : cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.adaptersAreSorted) {
            return this.adapters;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.adaptersAreSorted) {
                return this.adapters;
            }
            if (this.adapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters);
                LoadingOrder.sort(list);
                this.adapters = list;
            }
            this.adaptersAreSorted = true;
        }
        return this.adapters;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            return result;
        }
        HashSet duplicates = this instanceof BeanExtensionPoint ? null : new HashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.listeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            @Nullable T extension = this.processAdapter(adapters.get(i), listeners, result, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result[extensionIndex++] = extension;
        }
        if (extensionIndex != result.length) {
            result = Arrays.copyOf(result, extensionIndex);
        }
        ActivityCategory category = this.componentManager.getActivityCategory(true);
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        return result;
    }

    @Nullable
    private synchronized T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        try {
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            @Nullable T instance = adapter.createInstance(this.componentManager);
            if (instance == null && LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
            return instance;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result, @Nullable Set<T> duplicates, @NotNull Class<T> extensionClassForCheck, @NotNull List<? extends ExtensionComponentAdapter> adapters) {
        try {
            Condition duplicate;
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated$intellij_platform_extensions() && !this.isDynamic;
            @Nullable T extension = adapter.createInstance(this.componentManager);
            if (extension == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(adapter + " not loaded because it reported that not applicable");
                }
                return null;
            }
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = ContainerUtil.find(duplicates, d -> d.equals(extension));
                assert (result != null);
            } else {
                this.checkExtensionType(extension, extensionClassForCheck, adapter);
                if (isNotifyThatAdded) {
                    this.notifyListeners(false, Collections.singletonList(adapter), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result) + ";\n  adapters:        " + adapters);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean checkThatClassloaderIsActive(@NotNull ExtensionComponentAdapter adapter) {
        ClassLoader classLoader = adapter.pluginDescriptor.getPluginClassLoader();
        if (classLoader instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader)).getState() != 1) {
            LOG.warn(adapter + " not loaded because classloader is being unloaded");
            return false;
        }
        return true;
    }

    @TestOnly
    @ApiStatus.Internal
    public final synchronized void maskAll(final @NotNull List<? extends T> newList, @NotNull Disposable parentDisposable, final boolean fireEvents) {
        if (POINTS_IN_READONLY_MODE == null) {
            POINTS_IN_READONLY_MODE = Collections.newSetFromMap(new IdentityHashMap());
        } else {
            this.assertNotReadOnlyMode();
        }
        final List<T> oldList = this.cachedExtensions;
        final Object[] oldArray = this.cachedExtensionsAsArray;
        final List<ExtensionComponentAdapter> oldAdapters = this.adapters;
        final boolean oldAdaptersAreSorted = this.adaptersAreSorted;
        this.cachedExtensions = ContainerUtil.immutableList(newList);
        this.cachedExtensionsAsArray = newList.toArray((Object[])Array.newInstance(this.getExtensionClass(), 0));
        this.adapters = ContainerUtil.map(newList, it -> new ObjectComponentAdapter(it, this.pluginDescriptor, LoadingOrder.ANY));
        this.adaptersAreSorted = true;
        POINTS_IN_READONLY_MODE.add(this);
        ExtensionPointListener<T>[] listeners = this.listeners;
        if (fireEvents && listeners.length > 0) {
            if (oldList != null) {
                this.doNotifyListeners(true, oldList, listeners);
            }
            this.doNotifyListeners(false, newList, this.listeners);
        }
        this.clearUserCache();
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TestOnly
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    POINTS_IN_READONLY_MODE.remove(ExtensionPointImpl.this);
                    ExtensionPointImpl.this.cachedExtensions = oldList;
                    ExtensionPointImpl.access$502(ExtensionPointImpl.this, oldArray);
                    ExtensionPointImpl.this.adapters = oldAdapters;
                    ExtensionPointImpl.this.adaptersAreSorted = oldAdaptersAreSorted;
                    ExtensionPointListener[] listeners = ExtensionPointImpl.this.listeners;
                    if (fireEvents && listeners.length > 0) {
                        ExtensionPointImpl.this.doNotifyListeners(true, newList, listeners);
                        if (oldList != null) {
                            ExtensionPointImpl.this.doNotifyListeners(false, oldList, listeners);
                        }
                    }
                    ExtensionPointImpl.this.clearUserCache();
                }
            }
        });
    }

    @TestOnly
    private void doNotifyListeners(boolean isRemoved, @NotNull List<? extends T> extensions, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        for (ExtensionPointListener<T> listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (T extension : extensions) {
                try {
                    if (isRemoved) {
                        listener.extensionRemoved(extension, this.pluginDescriptor);
                        continue;
                    }
                    listener.extensionAdded(extension, this.pluginDescriptor);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void unregisterExtension(@NotNull T extension) {
        if (!this.unregisterExtensions((__, adapter) -> !adapter.isInstanceCreated$intellij_platform_extensions() || adapter.createInstance(this.componentManager) != extension, true)) {
            LOG.warn("Extension to be removed not found: " + extension);
        }
    }

    @Override
    public final void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister = extensionClass.getCanonicalName();
        if (!this.unregisterExtensions((cls, adapter) -> !cls.equals(classNameToUnregister), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    @Override
    public final boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassNameFilter, boolean stopAfterFirstMatch) {
        ArrayList listenerCallbacks = new ArrayList();
        ArrayList priorityListenerCallbacks = new ArrayList();
        boolean result = this.unregisterExtensions(stopAfterFirstMatch, priorityListenerCallbacks, listenerCallbacks, (? super ExtensionComponentAdapter adapter) -> extensionClassNameFilter.test(adapter.getAssignableToClassName(), (ExtensionComponentAdapter)adapter));
        for (Runnable callback : priorityListenerCallbacks) {
            callback.run();
        }
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result;
    }

    final synchronized boolean unregisterExtensions(boolean stopAfterFirstMatch, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks, @NotNull Predicate<? super ExtensionComponentAdapter> extensionToKeepFilter) {
        ExtensionPointListener<T>[] listeners = this.listeners;
        ArrayList<ExtensionComponentAdapter> removedAdapters = null;
        List<ExtensionComponentAdapter> adapters = this.adapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionToKeepFilter.test(adapter)) continue;
            if (adapters == this.adapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (listeners.length != 0) {
                if (removedAdapters == null) {
                    removedAdapters = new ArrayList<ExtensionComponentAdapter>();
                }
                removedAdapters.add(adapter);
            }
            if (stopAfterFirstMatch) break;
        }
        if (adapters == this.adapters) {
            return false;
        }
        this.clearCache();
        this.adapters = adapters;
        if (removedAdapters == null) {
            return true;
        }
        List<ExtensionPointListener<T>> priorityListeners = ContainerUtil.filter(listeners, listener -> listener instanceof ExtensionPointPriorityListener);
        List<ExtensionPointListener<T>> regularListeners = ContainerUtil.filter(listeners, listener -> !(listener instanceof ExtensionPointPriorityListener));
        ArrayList<ExtensionComponentAdapter> finalRemovedAdapters = removedAdapters;
        if (!priorityListeners.isEmpty()) {
            priorityListenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, priorityListeners.toArray(ExtensionPointListener.Companion.emptyArray())));
        }
        if (!regularListeners.isEmpty()) {
            listenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, regularListeners.toArray(ExtensionPointListener.Companion.emptyArray())));
        }
        return true;
    }

    abstract void unregisterExtensions(@NotNull ComponentManager var1, @NotNull PluginDescriptor var2, @NotNull List<? super Runnable> var3, @NotNull List<? super Runnable> var4);

    private void notifyListeners(boolean isRemoved, @NotNull List<? extends ExtensionComponentAdapter> adapters, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        for (ExtensionPointListener listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (ExtensionComponentAdapter extensionComponentAdapter : adapters) {
                if (isRemoved && !extensionComponentAdapter.isInstanceCreated$intellij_platform_extensions()) continue;
                try {
                    @Nullable T extension = extensionComponentAdapter.createInstance(this.componentManager);
                    if (extension == null) continue;
                    if (isRemoved) {
                        listener.extensionRemoved(extension, extensionComponentAdapter.pluginDescriptor);
                        continue;
                    }
                    listener.extensionAdded(extension, extensionComponentAdapter.pluginDescriptor);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded = this.addListener(listener);
        if (!isAdded) {
            return;
        }
        if (invokeForLoadedExtensions) {
            this.notifyListeners(false, this.getSortedAdapters(), new ExtensionPointListener[]{listener});
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        return LISTENER_ARRAY_FACTORY;
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (ArrayUtilRt.indexOf((Object[])this.listeners, listener, (int)0, (int)this.listeners.length) != -1) {
            return false;
        }
        this.listeners = listener instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener, this.listeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.listeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    @Override
    public final void addExtensionPointListener(final @NotNull ExtensionPointChangeListener listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        this.addExtensionPointListener(new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.extensionListChanged();
            }
        }, invokeForLoadedExtensions, parentDisposable);
    }

    @Override
    public final synchronized void addChangeListener(final @NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        ExtensionPointAdapter listenerAdapter = new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.run();
            }
        };
        this.listeners = ArrayUtil.append(this.listeners, listenerAdapter, ExtensionPointImpl.listenerArrayFactory());
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listenerAdapter));
        }
    }

    @Override
    public final synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        this.listeners = ArrayUtil.remove(this.listeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    public final synchronized void reset() {
        List<ExtensionComponentAdapter> adapters = this.adapters;
        this.adapters = Collections.emptyList();
        this.clearCache();
        if (!adapters.isEmpty() && this.listeners.length > 0) {
            this.notifyListeners(true, adapters, this.listeners);
        }
        this.listeners = ExtensionPointListener.Companion.emptyArray();
        this.extensionClass = null;
    }

    @NotNull
    public final Class<T> getExtensionClass() {
        Class<T> extensionClass = this.extensionClass;
        if (extensionClass == null) {
            try {
                this.extensionClass = extensionClass = this.componentManager.loadClass(this.className, this.pluginDescriptor);
            }
            catch (ClassNotFoundException e) {
                throw this.componentManager.createError(e, this.pluginDescriptor.getPluginId());
            }
        }
        return extensionClass;
    }

    public final String toString() {
        return this.getName();
    }

    final synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters.size() + 1);
        list.addAll(this.adapters);
        list.add(adapter);
        this.adapters = list;
        this.clearCache();
    }

    final void clearUserCache() {
        ConcurrentMap<?, Map<?, ?>> map = this.keyMapperToCacheRef.get();
        if (map != null) {
            map.clear();
        }
    }

    private void clearCache() {
        this.cachedExtensions = null;
        this.cachedExtensionsAsArray = null;
        this.adaptersAreSorted = false;
        this.clearUserCache();
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    abstract ExtensionComponentAdapter createAdapter(@NotNull ExtensionDescriptor var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    public final synchronized void registerExtensions(@NotNull List<ExtensionDescriptor> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<? super Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters = this.adapters;
        if (adapters == Collections.emptyList()) {
            this.adapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.adaptersAreSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (ExtensionDescriptor extensionElement : extensionElements) {
            if (extensionElement.os != null && !this.componentManager.isSuitableForOs(extensionElement.os)) continue;
            adapters.add(this.createAdapter(extensionElement, pluginDescriptor, this.componentManager));
        }
        int newSize = adapters.size();
        this.clearCache();
        ExtensionPointListener[] listeners = this.listeners;
        if (listenerCallbacks == null || listeners.length == 0) {
            return;
        }
        List addedAdapters = Collections.emptyList();
        for (ExtensionPointListener<T> extensionPointListener : listeners) {
            if (extensionPointListener instanceof ExtensionPointAdapter) continue;
            List<ExtensionComponentAdapter> newlyAddedUnsortedList = adapters.subList(oldSize, newSize);
            Set newlyAddedSet = Collections.newSetFromMap(new IdentityHashMap(newlyAddedUnsortedList.size()));
            newlyAddedSet.addAll(newlyAddedUnsortedList);
            addedAdapters = new ArrayList(newlyAddedSet.size());
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                if (!newlyAddedSet.contains(adapter)) continue;
                addedAdapters.add(adapter);
            }
            break;
        }
        List finalAddedAdapters = addedAdapters;
        listenerCallbacks.add(() -> this.notifyListeners(false, finalAddedAdapters, listeners));
    }

    @TestOnly
    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        for (ExtensionPointListener<T> listener : this.listeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass, boolean isRequired, @NotNull ThreeState strictMatch) {
        List<T> extensionsCache;
        if (strictMatch != ThreeState.NO) {
            @Nullable V result = this.findExtensionByExactClass(aClass);
            if (result != null) {
                return result;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionsCache = this.cachedExtensions) == null) {
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                try {
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass(this.componentManager))) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.pluginDescriptor.getPluginId());
                }
            }
        } else {
            for (Object extension : extensionsCache) {
                if (!aClass.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            @NonNls String message = "cannot find extension implementation " + aClass + "(epName=" + this.getName() + ", extensionCount=" + this.size();
            List<T> cache = this.cachedExtensions;
            if (cache != null) {
                message = message + ", cachedExtensions";
            }
            if (this.isInReadOnlyMode()) {
                message = message + ", point in read-only mode";
            }
            message = message + ")";
            throw this.componentManager.createError(message, this.getPluginDescriptor().getPluginId());
        }
        return null;
    }

    @NotNull
    public final <V> @NotNull List<@NotNull T> findExtensions(@NotNull Class<V> aClass) {
        List<T> extensionsCache = this.cachedExtensions;
        if (extensionsCache == null) {
            ArrayList<T> suitableInstances = new ArrayList<T>();
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                try {
                    T instance;
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass(this.componentManager)) || (instance = this.processAdapter(adapter)) == null) continue;
                    suitableInstances.add(instance);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.pluginDescriptor.getPluginId());
                }
            }
            return suitableInstances;
        }
        return ContainerUtil.filter(extensionsCache, aClass::isInstance);
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass) {
        List<T> cachedExtensions = this.cachedExtensions;
        if (cachedExtensions == null) {
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                Object classOrName = adapter.implementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass.getName()) : classOrName == aClass)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : cachedExtensions) {
                if (aClass != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    public static void setCheckCanceledAction(@NotNull Runnable checkCanceled) {
        CHECK_CANCELED = () -> {
            block2: {
                try {
                    checkCanceled.run();
                }
                catch (ProcessCanceledException e) {
                    if (ExtensionPointImpl.isInsideClassInitializer(e.getStackTrace())) break block2;
                    throw e;
                }
            }
        };
    }

    private static boolean isInsideClassInitializer(StackTraceElement @NotNull [] trace) {
        return ContainerUtil.exists(trace, s -> "<clinit>".equals(s.getMethodName()));
    }

    static /* synthetic */ Object[] access$502(ExtensionPointImpl x0, Object[] x1) {
        x0.cachedExtensionsAsArray = x1;
        return x1;
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? ExtensionPointListener.Companion.emptyArray() : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T componentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder, (__, ___) -> extension.getClass());
            this.componentInstance = extension;
        }

        @Override
        public boolean isInstanceCreated$intellij_platform_extensions() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            return (I)this.componentInstance;
        }
    }
}

