/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartExtensionPoint<Extension, V> {
    private final Collection<V> myExplicitExtensions;
    private volatile ExtensionPoint<@NotNull Extension> myExtensionPoint;
    private volatile List<V> myCache;
    private final ExtensionPointAndAreaListener<Extension> myExtensionPointAndAreaListener;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        this.myExplicitExtensions = explicitExtensions;
        this.myExtensionPointAndAreaListener = new ExtensionPointAndAreaListener<Extension>(){

            @Override
            public void areaReplaced(@NotNull ExtensionsArea oldArea) {
                this.dropCache();
            }

            @Override
            public void extensionAdded(@NotNull Extension extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.dropCache();
            }

            @Override
            public void extensionRemoved(@NotNull Extension extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.dropCache();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            private void dropCache() {
                if (SmartExtensionPoint.this.myCache == null) {
                    return;
                }
                Collection collection = SmartExtensionPoint.this.myExplicitExtensions;
                synchronized (collection) {
                    if (SmartExtensionPoint.this.myCache != null) {
                        SmartExtensionPoint.this.myCache = null;
                        @NotNull ExtensionPoint extensionPoint = SmartExtensionPoint.this.myExtensionPoint;
                        if (extensionPoint != null) {
                            extensionPoint.removeExtensionPointListener(this);
                            SmartExtensionPoint.this.myExtensionPoint = null;
                        }
                    }
                }
            }
        };
    }

    @NotNull
    protected abstract @NotNull ExtensionPoint<@NotNull Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<V> getExtensions() {
        List<V> result = this.myCache;
        if (result != null) {
            return result;
        }
        ExtensionPoint<@NotNull Extension> extensionPoint = this.myExtensionPoint;
        if (extensionPoint == null) {
            extensionPoint = this.getExtensionPoint();
            this.myExtensionPoint = extensionPoint;
        }
        List registeredExtensions = ContainerUtil.mapNotNull(extensionPoint.getExtensionList(), this::getExtension);
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            result = this.myCache;
            if (result != null) {
                return result;
            }
            extensionPoint.addExtensionPointListener(this.myExtensionPointAndAreaListener, false, null);
            result = new ArrayList<V>(this.myExplicitExtensions.size() + registeredExtensions.size());
            result.addAll(this.myExplicitExtensions);
            result.addAll(registeredExtensions);
            this.myCache = result;
            return result;
        }
    }
}

