/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Extensions {
    private static ExtensionsAreaImpl ourRootArea;

    private Extensions() {
    }

    public static void setRootArea(@NotNull ExtensionsAreaImpl area) {
        ourRootArea = area;
    }

    @TestOnly
    public static void setRootArea(@NotNull ExtensionsAreaImpl area, @NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl oldRootArea = ourRootArea;
        ourRootArea = area;
        Disposer.register(parentDisposable, () -> {
            ourRootArea.notifyAreaReplaced(oldRootArea);
            ourRootArea = oldRootArea;
        });
    }

    @Deprecated
    public static ExtensionsArea getRootArea() {
        return ourRootArea;
    }

    @Deprecated
    @NotNull
    public static ExtensionsArea getArea(@Nullable(value="null means root") @Nullable(value="null means root") AreaInstance areaInstance) {
        return areaInstance == null ? ourRootArea : areaInstance.getExtensionArea();
    }

    @Deprecated
    public static <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return extensionPointName.getExtensions();
    }

    @Deprecated
    public static <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, @Nullable AreaInstance areaInstance) {
        return extensionPointName.getExtensions(areaInstance);
    }

    @Deprecated
    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        return extensionPointName.findExtensionOrFail(extClass);
    }
}

