/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AttributesFlyweight {
    private static final ConcurrentMap<FlyweightKey, AttributesFlyweight> entries = new ConcurrentHashMap<FlyweightKey, AttributesFlyweight>();
    private static final ThreadLocal<FlyweightKey> ourKey = new ThreadLocal();
    private final int myHashCode;
    private final Color myForeground;
    private final Color myBackground;
    @JdkConstants.FontStyle
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    @NotNull
    private final @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> myAdditionalEffects;
    private final Color myErrorStripeColor;
    private static final int EFFECT_BORDER = 0;
    private static final int EFFECT_LINE = 1;
    private static final int EFFECT_WAVE = 2;
    private static final int EFFECT_STRIKEOUT = 3;
    private static final int EFFECT_BOLD_LINE = 4;
    private static final int EFFECT_BOLD_DOTTED_LINE = 5;

    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        return AttributesFlyweight.create(foreground, background, fontType, effectColor, effectType, Collections.emptyMap(), errorStripeColor);
    }

    @ApiStatus.Experimental
    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, @NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> additionalEffects, Color errorStripeColor) {
        FlyweightKey key = ourKey.get();
        if (key == null) {
            key = new FlyweightKey();
            ourKey.set(key);
        }
        key.foreground = foreground;
        key.background = background;
        key.fontType = fontType;
        key.effectColor = effectColor;
        key.effectType = effectType;
        key.myAdditionalEffects = additionalEffects.isEmpty() ? Collections.emptyMap() : new EnumMap<EffectType, Color>(additionalEffects);
        key.errorStripeColor = errorStripeColor;
        AttributesFlyweight flyweight = (AttributesFlyweight)entries.get(key);
        if (flyweight != null) {
            return flyweight;
        }
        return ConcurrencyUtil.cacheOrGet(entries, key.clone(), new AttributesFlyweight(key));
    }

    private AttributesFlyweight(@NotNull FlyweightKey key) {
        this.myForeground = key.foreground;
        this.myBackground = key.background;
        this.myFontType = key.fontType;
        this.myEffectColor = key.effectColor;
        this.myEffectType = key.effectType;
        this.myErrorStripeColor = key.errorStripeColor;
        this.myAdditionalEffects = key.myAdditionalEffects;
        this.myHashCode = key.hashCode();
    }

    @NotNull
    static AttributesFlyweight create(@NotNull Element element) throws InvalidDataException {
        Color FOREGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "FOREGROUND"));
        Color BACKGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "BACKGROUND"));
        Color EFFECT_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "EFFECT_COLOR"));
        Color ERROR_STRIPE_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "ERROR_STRIPE_COLOR"));
        int fontType = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "FONT_TYPE", "0"));
        if (fontType < 0 || fontType > 3) {
            fontType = 0;
        }
        int FONT_TYPE = fontType;
        int EFFECT_TYPE = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "EFFECT_TYPE", "0"));
        return AttributesFlyweight.create(FOREGROUND, BACKGROUND, FONT_TYPE, EFFECT_COLOR, AttributesFlyweight.toEffectType(EFFECT_TYPE), Collections.emptyMap(), ERROR_STRIPE_COLOR);
    }

    private static void writeColor(@NotNull Element element, @NotNull String fieldName, Color color) {
        if (color != null) {
            String string2 = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
            JDOMExternalizerUtil.writeField(element, fieldName, string2);
        }
    }

    void writeExternal(@NotNull Element element) {
        AttributesFlyweight.writeColor(element, "FOREGROUND", this.getForeground());
        AttributesFlyweight.writeColor(element, "BACKGROUND", this.getBackground());
        int fontType = this.getFontType();
        if (fontType != 0) {
            JDOMExternalizerUtil.writeField(element, "FONT_TYPE", String.valueOf(fontType));
        }
        AttributesFlyweight.writeColor(element, "EFFECT_COLOR", this.getEffectColor());
        AttributesFlyweight.writeColor(element, "ERROR_STRIPE_COLOR", this.getErrorStripeColor());
        int effectType = AttributesFlyweight.fromEffectType(this.getEffectType());
        if (effectType != 0) {
            JDOMExternalizerUtil.writeField(element, "EFFECT_TYPE", String.valueOf(effectType));
        }
    }

    private static int fromEffectType(EffectType effectType) {
        if (effectType == null) {
            return -1;
        }
        switch (effectType) {
            case BOXED: {
                return 0;
            }
            case LINE_UNDERSCORE: {
                return 1;
            }
            case BOLD_LINE_UNDERSCORE: {
                return 4;
            }
            case STRIKEOUT: {
                return 3;
            }
            case WAVE_UNDERSCORE: {
                return 2;
            }
            case BOLD_DOTTED_LINE: {
                return 5;
            }
        }
        return -1;
    }

    private static EffectType toEffectType(int effectType) {
        switch (effectType) {
            case 0: {
                return EffectType.BOXED;
            }
            case 4: {
                return EffectType.BOLD_LINE_UNDERSCORE;
            }
            case 1: {
                return EffectType.LINE_UNDERSCORE;
            }
            case 3: {
                return EffectType.STRIKEOUT;
            }
            case 2: {
                return EffectType.WAVE_UNDERSCORE;
            }
            case 5: {
                return EffectType.BOLD_DOTTED_LINE;
            }
        }
        return null;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    @NotNull
    @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> getAdditionalEffects() {
        return this.myAdditionalEffects;
    }

    @ApiStatus.Experimental
    public boolean hasEffects() {
        return this.myEffectColor != null && this.myEffectType != null || !this.myAdditionalEffects.isEmpty();
    }

    @NotNull
    public Map<EffectType, Color> getAllEffects() {
        if (this.myAdditionalEffects.isEmpty()) {
            return this.myEffectType == null || this.myEffectColor == null ? Collections.emptyMap() : Collections.singletonMap(this.myEffectType, this.myEffectColor);
        }
        TextAttributesEffectsBuilder builder = TextAttributesEffectsBuilder.create();
        this.myAdditionalEffects.forEach(builder::coverWith);
        builder.coverWith(this.myEffectType, this.myEffectColor);
        return builder.getEffectsMap();
    }

    Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    @NotNull
    public AttributesFlyweight withForeground(Color foreground) {
        return Comparing.equal((Object)foreground, (Object)this.myForeground) ? this : AttributesFlyweight.create(foreground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withBackground(Color background) {
        return Comparing.equal((Object)background, (Object)this.myBackground) ? this : AttributesFlyweight.create(this.myForeground, background, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withFontType(@JdkConstants.FontStyle int fontType) {
        return fontType == this.myFontType ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, fontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withEffectColor(Color effectColor) {
        return Comparing.equal((Object)effectColor, (Object)this.myEffectColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, effectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withEffectType(EffectType effectType) {
        return Comparing.equal((Object)((Object)effectType), (Object)((Object)this.myEffectType)) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, effectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withErrorStripeColor(Color stripeColor) {
        return Comparing.equal((Object)stripeColor, (Object)this.myErrorStripeColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, stripeColor);
    }

    @ApiStatus.Experimental
    @NotNull
    public AttributesFlyweight withAdditionalEffects(@NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> additionalEffects) {
        return Comparing.equal(additionalEffects, this.myAdditionalEffects) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, additionalEffects, this.myErrorStripeColor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (!Objects.equals(this.myBackground, that.myBackground)) {
            return false;
        }
        if (!Objects.equals(this.myEffectColor, that.myEffectColor)) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (!Objects.equals(this.myErrorStripeColor, that.myErrorStripeColor)) {
            return false;
        }
        if (!Objects.equals(this.myForeground, that.myForeground)) {
            return false;
        }
        return this.myAdditionalEffects.equals(that.myAdditionalEffects);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static final class FlyweightKey
    implements Cloneable {
        private Color foreground;
        private Color background;
        @JdkConstants.FontStyle
        private int fontType;
        private Color effectColor;
        private EffectType effectType;
        private Color errorStripeColor;
        @NotNull
        private @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> myAdditionalEffects = Collections.emptyMap();

        private FlyweightKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyweightKey)) {
                return false;
            }
            FlyweightKey key = (FlyweightKey)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            if (!Objects.equals(this.background, key.background)) {
                return false;
            }
            if (!Objects.equals(this.effectColor, key.effectColor)) {
                return false;
            }
            if (this.effectType != key.effectType) {
                return false;
            }
            if (!Objects.equals(this.errorStripeColor, key.errorStripeColor)) {
                return false;
            }
            if (!Objects.equals(this.foreground, key.foreground)) {
                return false;
            }
            return this.myAdditionalEffects.equals(key.myAdditionalEffects);
        }

        public int hashCode() {
            int result = this.foreground != null ? this.foreground.hashCode() : 0;
            result = 31 * result + (this.background != null ? this.background.hashCode() : 0);
            result = 31 * result + this.fontType;
            result = 31 * result + (this.effectColor != null ? this.effectColor.hashCode() : 0);
            result = 31 * result + (this.effectType != null ? this.effectType.hashCode() : 0);
            result = 31 * result + (this.errorStripeColor != null ? this.errorStripeColor.hashCode() : 0);
            result = 31 * result + this.myAdditionalEffects.hashCode();
            return result;
        }

        protected FlyweightKey clone() {
            try {
                return (FlyweightKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

