/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    public static final TextAttributesKey[] EMPTY_ARRAY = new TextAttributesKey[0];
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final String TEMP_PREFIX = "TEMP::";
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap<String, TextAttributesKey>();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = NullableLazyValue.volatileLazyNullable(() -> ApplicationManager.getApplication().getService(TextAttributeKeyDefaultsProvider.class));
    @NotNull
    private final String myExternalName;
    private final TextAttributes myDefaultAttributes;
    private final TextAttributesKey myFallbackAttributeKey;
    private static final ThreadLocal<Set<String>> CALLED_RECURSIVELY = ThreadLocal.withInitial(() -> new HashSet());
    @Deprecated
    static final TextAttributesKey DUMMY_DEPRECATED_ATTRIBUTES = TextAttributesKey.createTextAttributesKey("__deprecated__");

    private TextAttributesKey(@NotNull String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        this.myExternalName = externalName;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null) {
            this.checkForCycle(fallbackAttributeKey);
        }
    }

    private void checkForCycle(@NotNull TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey key = fallbackAttributeKey;
        while (key != null) {
            if (this.equals(key)) {
                throw new IllegalArgumentException("Can't use this fallback key: " + fallbackAttributeKey + ": Cycle detected: " + StringUtil.join(JBIterable.generate(this.myFallbackAttributeKey, o -> o == this ? null : o.myFallbackAttributeKey), "->"));
            }
            key = key.myFallbackAttributeKey;
        }
    }

    public TextAttributesKey(@NotNull Element element) {
        String name = JDOMExternalizerUtil.readField(element, "myExternalName");
        Element myDefaultAttributesElement = JDOMExternalizerUtil.readOption(element, "myDefaultAttributes");
        TextAttributes defaultAttributes = myDefaultAttributesElement == null ? null : new TextAttributes(myDefaultAttributesElement);
        this.myExternalName = Objects.requireNonNull(name);
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = null;
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        return ourRegistry.computeIfAbsent(externalName, name -> new TextAttributesKey((String)name, null, null));
    }

    @NlsSafe
    public String toString() {
        return this.myExternalName + (this.myFallbackAttributeKey == null && this.myDefaultAttributes == null ? "" : " (") + (this.myFallbackAttributeKey == null ? "" : "fallbackKey: " + this.myFallbackAttributeKey) + (this.myDefaultAttributes == null ? "" : "; defaultAttributes: " + this.myDefaultAttributes) + (this.myFallbackAttributeKey == null && this.myDefaultAttributes == null ? "" : ")");
    }

    @NotNull
    @NlsSafe
    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element) {
        JDOMExternalizerUtil.writeField(element, "myExternalName", this.myExternalName);
        if (this.myDefaultAttributes != null) {
            Element option = JDOMExternalizerUtil.writeOption(element, "myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextAttributes getDefaultAttributes() {
        TextAttributeKeyDefaultsProvider provider;
        TextAttributes defaultAttributes = this.myDefaultAttributes;
        if (defaultAttributes == null && (provider = ourDefaultsProvider.getValue()) != null) {
            Set<String> called = CALLED_RECURSIVELY.get();
            if (!called.add(this.myExternalName)) {
                return null;
            }
            try {
                TextAttributes textAttributes = ObjectUtils.notNull(provider.getDefaultAttributes(this), NULL_ATTRIBUTES);
                return textAttributes;
            }
            finally {
                called.remove(this.myExternalName);
            }
        }
        return defaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        return TextAttributesKey.getOrCreate(externalName, defaultAttributes, null);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        return TextAttributesKey.getOrCreate(externalName, null, fallbackAttributeKey);
    }

    @NotNull
    private static TextAttributesKey getOrCreate(@NotNull @NonNls String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey existing = (TextAttributesKey)ourRegistry.get(externalName);
        if (existing != null && (defaultAttributes == null || Comparing.equal((Object)existing.myDefaultAttributes, (Object)defaultAttributes)) && (fallbackAttributeKey == null || Comparing.equal((Object)existing.myFallbackAttributeKey, (Object)fallbackAttributeKey))) {
            return existing;
        }
        return ourRegistry.compute(externalName, (oldName, oldKey) -> TextAttributesKey.mergeKeys(oldName, oldKey, defaultAttributes, fallbackAttributeKey));
    }

    @NotNull
    private static TextAttributesKey mergeKeys(@NonNls @NotNull String externalName, @Nullable TextAttributesKey oldKey, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        if (oldKey == null) {
            return new TextAttributesKey(externalName, defaultAttributes, fallbackAttributeKey);
        }
        if (oldKey.myFallbackAttributeKey != null && !oldKey.myFallbackAttributeKey.equals(fallbackAttributeKey)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', fallbackAttributeKey:'" + fallbackAttributeKey + "')  was already registered with the other fallback attribute key: " + oldKey.myFallbackAttributeKey));
        }
        if (oldKey.myDefaultAttributes != null && !oldKey.myDefaultAttributes.equals(defaultAttributes)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', defaultAttributes:'" + defaultAttributes + "')  was already registered with the other defaultAttributes: " + oldKey.myDefaultAttributes));
        }
        TextAttributes newDefaults = ObjectUtils.chooseNotNull(defaultAttributes, oldKey.myDefaultAttributes);
        TextAttributesKey newFallback = ObjectUtils.chooseNotNull(fallbackAttributeKey, oldKey.myFallbackAttributeKey);
        return new TextAttributesKey(externalName, newDefaults, newFallback);
    }

    @NotNull
    public static TextAttributesKey createTempTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        return TextAttributesKey.createTextAttributesKey(TEMP_PREFIX + externalName, defaultAttributes);
    }

    @Nullable
    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setFallbackAttributeKey(@Nullable TextAttributesKey fallbackAttributeKey) {
    }

    @TestOnly
    static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        ourRegistry.remove(externalName);
    }

    public static boolean isTemp(@NotNull TextAttributesKey key) {
        return key.getExternalName().startsWith(TEMP_PREFIX);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public static List<TextAttributesKey> getAllKeys() {
        return new ArrayList<TextAttributesKey>(ourRegistry.values());
    }

    @FunctionalInterface
    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey var1);
    }
}

