/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance(ColorKey.class);
    public static final Key<Function<ColorKey, Color>> FUNCTION_KEY = Key.create("COLOR_KEY_FUNCTION");
    private static final ConcurrentMap<String, ColorKey> ourRegistry = new ConcurrentHashMap<String, ColorKey>();
    private final String myExternalName;
    private final Color myDefaultColor;
    private final ColorKey myFallbackColorKey;

    private ColorKey(@NotNull String externalName, Color defaultColor, ColorKey fallBackColorKey) {
        this.myExternalName = externalName;
        this.myDefaultColor = defaultColor;
        this.myFallbackColorKey = fallBackColorKey;
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        return ourRegistry.computeIfAbsent(externalName, s -> new ColorKey((String)s, null, null));
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        return this.myDefaultColor;
    }

    @Nullable
    public ColorKey getFallbackColorKey() {
        return this.myFallbackColorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        return ColorKey.find(externalName);
    }

    @NotNull
    public static ColorKey createColorKeyWithFallback(@NonNls @NotNull String externalName, @Nullable ColorKey fallbackColorKey) {
        JBIterable<ColorKey> it;
        ColorKey existing = (ColorKey)ourRegistry.get(externalName);
        if (existing != null) {
            if (Comparing.equal((Object)existing.getFallbackColorKey(), (Object)fallbackColorKey)) {
                return existing;
            }
            ourRegistry.remove(externalName, existing);
        }
        ColorKey newKey = new ColorKey(externalName, existing == null ? null : existing.getDefaultColor(), fallbackColorKey);
        ColorKey res = ConcurrencyUtil.cacheOrGet(ourRegistry, externalName, newKey);
        if (fallbackColorKey != null && (it = JBIterable.generate(fallbackColorKey, o -> o == res ? null : o.myFallbackColorKey)).find((Condition<ColorKey>)((Condition)o -> o == res)) == res) {
            String cycle = StringUtil.join(it.map(ColorKey::getExternalName), "->");
            LOG.error("Cycle detected: " + cycle);
        }
        return res;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, @Nullable Color defaultColor) {
        ColorKey existing = (ColorKey)ourRegistry.get(externalName);
        if (existing != null) {
            if (Comparing.equal((Object)existing.getDefaultColor(), (Object)defaultColor)) {
                return existing;
            }
            ourRegistry.remove(externalName, existing);
        }
        ColorKey newKey = new ColorKey(externalName, defaultColor, existing == null ? null : existing.getFallbackColorKey());
        return ConcurrencyUtil.cacheOrGet(ourRegistry, externalName, newKey);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ColorKey && this.myExternalName.equals(((ColorKey)obj).myExternalName);
    }
}

