/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer
extends LineTokenizerBase<String> {
    private final char[] myChars;
    private final String myText;

    public LineTokenizer(@NotNull String text) {
        this.myChars = text.toCharArray();
        this.myText = text;
    }

    public String @NotNull [] execute() {
        ArrayList lines = new ArrayList();
        this.doExecute(lines);
        return ArrayUtilRt.toStringArray(lines);
    }

    @Override
    protected void addLine(List<? super String> lines, int start, int end, boolean appendNewLine) {
        if (appendNewLine) {
            lines.add(this.myText.substring(start, end) + "\n");
        } else {
            lines.add(this.myText.substring(start, end));
        }
    }

    @Override
    protected char charAt(int index) {
        return this.myChars[index];
    }

    @Override
    protected int length() {
        return this.myChars.length;
    }

    @Override
    @NotNull
    protected String substring(int start, int end) {
        return this.myText.substring(start, end);
    }

    @NotNull
    public static String concatLines(String @NotNull [] lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line);
        }
        return buffer.substring(0, buffer.length());
    }

    @NotNull
    public static String correctLineSeparators(@NotNull String text) {
        return LineTokenizer.concatLines(new LineTokenizer(text).execute());
    }
}

