/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrottledLogger {
    @NotNull
    private final Logger logger;
    private final long ignoreRepeatedMessagesInMs;
    private final AtomicLong lastLoggedAtMsHolder = new AtomicLong(0L);

    public ThrottledLogger(@NotNull Logger logger, long ignoreRepeatedMessagesInMs) {
        this.logger = Objects.requireNonNull(logger, "logger");
        if (ignoreRepeatedMessagesInMs < 0L) {
            throw new IllegalArgumentException("ignoreRepeatedMessagesInMs(=" + ignoreRepeatedMessagesInMs + ") must be >=0");
        }
        this.ignoreRepeatedMessagesInMs = ignoreRepeatedMessagesInMs;
    }

    @NotNull
    public Logger logger() {
        return this.logger;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, @Nullable Throwable t) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.debug(message, t);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, @Nullable Throwable t) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.info(message, t);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, @Nullable Throwable t) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.warn(message, t);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, @Nullable Throwable t) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.error(message, t);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    private void forwardLastLogged(long nowMs, long lastLoggedAt) {
        while (!this.lastLoggedAtMsHolder.compareAndSet(lastLoggedAt, nowMs) && (lastLoggedAt = this.lastLoggedAtMsHolder.get()) < nowMs) {
        }
    }

    public String toString() {
        return "ThrottledLogger[ignoreRepeatedMessagesInMs: " + this.ignoreRepeatedMessagesInMs + ", lastLoggedAtMs:" + this.lastLoggedAtMsHolder.get() + ", wrapped logger:" + this.logger + '}';
    }
}

