/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteCommandAction.class);
    private static final String DEFAULT_GROUP_ID = null;
    private final @NlsContexts.Command String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project) {
        return new BuilderImpl(project, new PsiElement[0]);
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        return new BuilderImpl(first.getProject(), (PsiElement[])ArrayUtil.prepend(first, others));
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project, PsiFile ... files2) {
        return new BuilderImpl(project, (PsiElement[])files2);
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project, Collection<? extends PsiElement> elementsToMakeWritable) {
        return new BuilderImpl(project, elementsToMakeWritable);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, PsiFile ... files2) {
        this(project, WriteCommandAction.getDefaultCommandName(), files2);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable @NlsContexts.Command String commandName, PsiFile ... files2) {
        this(project, commandName, DEFAULT_GROUP_ID, files2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected WriteCommandAction(@Nullable Project project, @Nullable @NlsContexts.Command String commandName, @Nullable String groupID, PsiFile ... files2) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files2.length == 0 ? PsiFile.EMPTY_ARRAY : files2;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NlsContexts.Command
    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> this.performWriteCommandAction(result));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        return result;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (this.myPsiFiles.length > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        Ref resultRef = new Ref(result);
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ((RunResult)resultRef.get()).run();
            resultRef.set(null);
        }));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected boolean isGlobalUndoAction() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    private void doExecuteCommand(@NotNull Runnable runnable) {
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), true);
    }

    @TestOnly
    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        WriteCommandAction.runWriteCommandAction(project, WriteCommandAction.getDefaultCommandName(), DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    @NlsContexts.Command
    private static String getDefaultCommandName() {
        return CoreBundle.message("command.name.undefined", new Object[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable @NlsContexts.Command String commandName, @Nullable String groupID, @NotNull Runnable runnable, PsiFile ... files2) {
        WriteCommandAction.writeCommandAction(project, files2).withName(commandName).withGroupId(groupID).run(() -> runnable.run());
    }

    public static <T> T runWriteCommandAction(Project project, @NotNull Computable<T> computable) {
        return (T)WriteCommandAction.writeCommandAction(project).compute(() -> computable.compute());
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, @NotNull ThrowableComputable<T, E> computable) throws E {
        return WriteCommandAction.writeCommandAction(project).compute(computable);
    }

    static /* synthetic */ String access$000() {
        return WriteCommandAction.getDefaultCommandName();
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_GROUP_ID;
    }

    private static final class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final Collection<? extends PsiElement> myPsiElements;
        private @NlsContexts.Command String myCommandName = WriteCommandAction.access$000();
        private String myGroupId = WriteCommandAction.access$100();
        private UndoConfirmationPolicy myUndoConfirmationPolicy;
        private boolean myGlobalUndoAction;
        private boolean myShouldRecordActionForActiveDocument = true;

        private BuilderImpl(Project project, @NotNull Collection<? extends PsiElement> elements) {
            this.myProject = project;
            this.myPsiElements = elements;
        }

        private BuilderImpl(Project project, PsiElement ... elements) {
            this.myProject = project;
            this.myPsiElements = Arrays.asList(elements);
        }

        @Override
        @NotNull
        public Builder withName(@NlsContexts.Command String name) {
            this.myCommandName = name;
            return this;
        }

        @Override
        @NotNull
        public Builder withGlobalUndo() {
            this.myGlobalUndoAction = true;
            return this;
        }

        @Override
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean value) {
            this.myShouldRecordActionForActiveDocument = value;
            return this;
        }

        @Override
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy policy) {
            if (this.myUndoConfirmationPolicy != null) {
                throw new IllegalStateException("do not call withUndoConfirmationPolicy() several times");
            }
            this.myUndoConfirmationPolicy = policy;
            return this;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            return this;
        }

        @Override
        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
            Application application = ApplicationManager.getApplication();
            boolean dispatchThread = application.isDispatchThread();
            if (!dispatchThread && application.isReadAccessAllowed()) {
                LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
                throw new IllegalStateException();
            }
            AtomicReference thrown = new AtomicReference();
            if (dispatchThread) {
                thrown.set(this.doRunWriteCommandAction(action));
            } else {
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> thrown.set(this.doRunWriteCommandAction(action)));
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
            if (thrown.get() != null) {
                throw (Throwable)thrown.get();
            }
        }

        private <E extends Throwable> E doRunWriteCommandAction(@NotNull ThrowableRunnable<E> action) {
            if (this.myPsiElements.size() > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(this.myPsiElements)) {
                return null;
            }
            AtomicReference thrown = new AtomicReference();
            Runnable wrappedRunnable = () -> {
                if (this.myGlobalUndoAction) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        action.run();
                    }
                    catch (Throwable e) {
                        thrown.set(e);
                    }
                });
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, wrappedRunnable, this.myCommandName, (Object)this.myGroupId, ObjectUtils.notNull(this.myUndoConfirmationPolicy, UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION), this.myShouldRecordActionForActiveDocument);
            return (E)((Throwable)thrown.get());
        }

        @Override
        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> action) throws E {
            AtomicReference result = new AtomicReference();
            this.run(() -> result.set(action.compute()));
            return (R)result.get();
        }
    }

    public static interface Builder {
        @Contract(pure=true)
        @NotNull
        public Builder withName(@Nullable @NlsContexts.Command String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGroupId(@Nullable String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGlobalUndo();

        @Contract(pure=true)
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }

    @Deprecated
    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files2) {
            super(project, files2);
        }

        protected Simple(Project project, @NlsContexts.Command String commandName, PsiFile ... files2) {
            super(project, commandName, files2);
        }

        protected Simple(Project project, @NlsContexts.Command String name, String groupID, PsiFile ... files2) {
            super(project, name, groupID, files2);
        }

        @Override
        protected void run(@NotNull Result<? super T> result) throws Throwable {
            this.run();
        }

        protected abstract void run() throws Throwable;
    }
}

