/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
final class WriteThread {
    private WriteThread() {
    }

    @NotNull
    private static Future<Void> submit(@NotNull Runnable runnable, ModalityState modalityState) {
        return WriteThread.submit(() -> {
            runnable.run();
            return null;
        }, modalityState);
    }

    @NotNull
    private static <T> Future<T> submit(@NotNull ThrowableComputable<? extends T, ?> computable, ModalityState modalityState) {
        CompletableFuture future = new CompletableFuture();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
            try {
                future.complete(computable.compute());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, modalityState);
        return future;
    }

    static void invokeAndWait(@NotNull Runnable runnable) {
        WriteThread.invokeAndWait(runnable, ModalityState.defaultModalityState());
    }

    static void invokeAndWait(@NotNull Runnable runnable, ModalityState modalityState) {
        try {
            WriteThread.submit(runnable, modalityState).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrowUnchecked(e.getCause());
        }
    }
}

