/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.properties.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String JRE_DIRECTORY = "jbr";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        return PathManager.getHomePath(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result = ourHomePath;
        if (result != null) {
            return result;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result = ourHomePath;
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result = explicit;
                if (!Files.isDirectory(Paths.get(result, new String[0]), new LinkOption[0])) {
                    ourHomePath = result;
                    throw new RuntimeException("Invalid home path '" + result + "'");
                }
            } else if (insideIde && (result = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result != null && SystemInfoRt.isWindows) {
                try {
                    result = Paths.get(result, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result, new String[0]));
            ourHomePath = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result = ourBinDirectories;
        if (result == null) {
            PathManager.getHomePath(true);
            result = ourBinDirectories;
        }
        return result;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        try {
            return PathManager.isUnderHomeDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean isUnderHomeDirectory(@NotNull Path target) {
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result = PathManager.getHomeDirFor(aClass);
        return result == null ? null : result.toString();
    }

    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        Path result = null;
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
            if (SystemInfoRt.isWindows && System.getProperties().containsKey("TEST_WORKSPACE")) {
                try {
                    root = root.toRealPath(new LinkOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
            }
            result = root;
        }
        return result;
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve(PROPERTIES_FILE_NAME), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve(BIN_DIRECTORY), Paths.get(PathManager.getCommunityHomePath(root.toString()), BIN_DIRECTORY)};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir : candidates) {
            String arch;
            if (binDirs.contains(dir) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            if (!SystemInfoRt.isWindows && !SystemInfoRt.isLinux) continue;
            String string2 = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir = dir.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        return PathManager.getHomePath() + '/' + BIN_DIRECTORY;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName) {
        Path file2 = PathManager.findBinFile(fileName);
        if (file2 != null) {
            return file2;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new RuntimeException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        return PathManager.getHomePath() + '/' + LIB_DIRECTORY;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        return PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
    }

    @NotNull
    public static String getBundledRuntimePath() {
        return PathManager.getHomePath() + '/' + JRE_DIRECTORY + (SystemInfoRt.isMac ? "/Contents/Home" : "");
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        if (ourCommonDataPath == null) {
            Path path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ourCommonDataPath = path;
        }
        return ourCommonDataPath;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        return Paths.get(PathManager.getConfigPath(), new String[0]);
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            return ourConfigPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
        return ourConfigPath;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            return ourScratchPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
        ourScratchPath = explicit != null ? explicit : PathManager.getConfigPath();
        return ourScratchPath;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
    }

    @NotNull
    public static String getOptionsPath() {
        return PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        return Paths.get(PathManager.getOptionsPath(), fileName + DEFAULT_EXT).toFile();
    }

    @NotNull
    public static Path getPluginsDir() {
        return Paths.get(PathManager.getPluginsPath(), new String[0]);
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            return ourPluginsPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
        ourPluginsPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
        return ourPluginsPath;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static Path getSystemDir() {
        return Paths.get(PathManager.getSystemPath(), new String[0]);
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
        return ourSystemPath;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
    }

    @NotNull
    public static String getDefaultUnixSystemPath(@NotNull String userHome, @NotNull String selector) {
        return PathManager.getUnixPlatformPath(userHome, selector, null, ".cache", "");
    }

    @NotNull
    public static String getTempPath() {
        return PathManager.getSystemPath() + "/tmp";
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        return Paths.get(indexRootPath, new String[0]);
    }

    @NotNull
    public static Path getLogDir() {
        return Paths.get(PathManager.getLogPath(), new String[0]);
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            return ourLogPath;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
        ourLogPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.getDefaultLogPathFor(PATHS_SELECTOR) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
        return ourLogPath;
    }

    @NotNull
    public static String getDefaultLogPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY);
    }

    @NotNull
    public static String getPluginTempPath() {
        return PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        URL url = classLoader.getResource(resourcePath);
        return url == null ? null : PathManager.extractRoot(url, "/" + resourcePath);
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result;
            try {
                result = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e);
            }
            String path = result.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)testPath, (CharSequence)testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot = url.indexOf("!/");
        if (pivot < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result;
            URL parsedUrl = new URL(jarPath);
            try {
                result = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e);
            }
            return result.getPath().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    public static void loadProperties() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(System.getProperty("user.home") + '/' + PROPERTIES_FILE_NAME);
        final String homePath = PathManager.getHomePath(true);
        for (Path binDir : PathManager.getBinDirectories()) {
            paths.add(binDir.resolve(PROPERTIES_FILE_NAME).toString());
        }
        final Properties sysProperties = System.getProperties();
        for (final String path : paths) {
            Path file2;
            Path path2 = file2 = path == null ? null : Paths.get(path, new String[0]);
            if (file2 == null) continue;
            try {
                InputStream inputStream = Files.newInputStream(file2, new OpenOption[0]);
                try {
                    new Properties(){

                        @Override
                        public Object put(Object key, Object value) {
                            if (PathManager.PROPERTY_HOME_PATH.equals(key) || PathManager.PROPERTY_HOME.equals(key)) {
                                PathManager.log(path + ": '" + key + "' cannot be redefined");
                            } else if (!sysProperties.containsKey(key)) {
                                sysProperties.put(key, PathManager.substituteVars((String)value, homePath));
                            }
                            return null;
                        }
                    }.load(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (AccessDeniedException | NoSuchFileException inputStream) {
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
        sysProperties.setProperty("disableJbScreenMenuBar", "true");
        if ("true".equals(sysProperties.getProperty("jbScreenMenuBar.enabled"))) {
            sysProperties.setProperty("apple.laf.useScreenMenuBar", "false");
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + '/' + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value = PathManager.getSystemPath();
                    }
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file2 = Paths.get(PathManager.getLibPath(), relativePath);
        if (!Files.exists(file2, new LinkOption[0])) {
            file2 = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        return file2.toFile();
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0]);
        if (!isRunningFromSources) {
            return homePath;
        }
        if (Files.isDirectory(Paths.get(homePath, "community/.idea"), new LinkOption[0])) {
            return homePath + "/community";
        }
        if (Files.isDirectory(Paths.get(homePath, "ultimate/community/.idea"), new LinkOption[0])) {
            return homePath + "/ultimate/community";
        }
        if (Files.isDirectory(Paths.get(homePath, "../../../community/.idea"), new LinkOption[0])) {
            return homePath + "/../../../community";
        }
        if (Files.isRegularFile(Paths.get(homePath, "../../Product.Root"), new LinkOption[0])) {
            return homePath + "/../ultimate/community";
        }
        return homePath;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot = PathManager.getJarForClass(aClass);
        return resourceRoot == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    @NotNull
    public static Path getJarArtifactPath(@NotNull String classesRoot, @NotNull String artifactName) {
        String artifactJarName = Strings.trimEnd(artifactName, ":jar") + ".jar";
        String artifactDirNameInBuildLayout = artifactName.replaceAll("\\W", "_");
        return PathManager.getArtifactPath(classesRoot, artifactJarName, "rt", artifactDirNameInBuildLayout);
    }

    @NotNull
    public static Path getArtifactPath(@NotNull String classesRoot, @NotNull String artifactFileName, @NotNull String artifactDirNameInPluginLayout, @NotNull String artifactDirNameInBuildLayout) {
        Path rootPath = Paths.get(classesRoot, new String[0]);
        if (Files.isRegularFile(rootPath, new LinkOption[0])) {
            return rootPath.resolveSibling(artifactDirNameInPluginLayout).resolve(artifactFileName);
        }
        Path outClassesDir = rootPath.getParent().getParent();
        Path artifactsDir = outClassesDir.resolveSibling("jps-artifacts");
        if (!Files.exists(artifactsDir, new LinkOption[0])) {
            artifactsDir = outClassesDir.resolve("artifacts");
        }
        return artifactsDir.resolve(artifactDirNameInBuildLayout).resolve(artifactFileName);
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        return Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property) {
        String path = System.getProperty(property);
        if (path == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir;
        String string2 = dir = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir == null || dir.isEmpty()) {
            dir = userHome + '/' + xdgDfl;
        }
        dir = dir + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir = dir + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir = dir + '/' + xdgSub;
        }
        return dir;
    }

    private static String vendorName() {
        String property = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property != null ? property : "JetBrains");
        }
        return property;
    }

    private static final class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

