/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AsyncExecutionService;
import com.intellij.openapi.application.BaseExpirableExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface AppUIExecutor
extends BaseExpirableExecutor<AppUIExecutor> {
    @NotNull
    public static AppUIExecutor onUiThread(@NotNull ModalityState modality) {
        return AsyncExecutionService.getService().createUIExecutor(modality);
    }

    @NotNull
    public static AppUIExecutor onWriteThread(@NotNull ModalityState modality) {
        return AsyncExecutionService.getService().createWriteThreadExecutor(modality);
    }

    @NotNull
    public static AppUIExecutor onUiThread() {
        return AppUIExecutor.onUiThread(ModalityState.defaultModalityState());
    }

    @NotNull
    public static AppUIExecutor onWriteThread() {
        return AppUIExecutor.onWriteThread(ModalityState.defaultModalityState());
    }

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor later();

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor withDocumentsCommitted(@NotNull Project var1);

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor inSmartMode(@NotNull Project var1);
}

