/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.ClassExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemPresentationProviders
extends ClassExtension<ItemPresentationProvider> {
    public static final ItemPresentationProviders INSTANCE = new ItemPresentationProviders();

    private ItemPresentationProviders() {
        super("com.intellij.itemPresentationProvider");
    }

    @Nullable
    public static ItemPresentation getItemPresentation(@NotNull NavigationItem element) {
        for (ItemPresentationProvider provider : INSTANCE.forKey(element.getClass())) {
            ItemPresentation presentation = provider.getPresentation(element);
            if (presentation == null) continue;
            return presentation;
        }
        return null;
    }
}

