/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.SideEffectGuardImpl;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.EnumSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface SideEffectGuard {
    public static <T, E extends Throwable> T computeWithoutSideEffects(ThrowableComputable<T, E> supplier) throws E {
        return SideEffectGuard.computeWithAllowedSideEffects(SideEffectGuardImpl.NO_EFFECTS, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithAllowedSideEffects(EnumSet<EffectType> effects, ThrowableComputable<T, E> supplier) throws E {
        EnumSet<EffectType> previous = SideEffectGuardImpl.ourSideEffects.get();
        SideEffectGuardImpl.ourSideEffects.set((EnumSet<EffectType>)effects.clone());
        try {
            Object object = supplier.compute();
            return (T)object;
        }
        finally {
            SideEffectGuardImpl.ourSideEffects.set(previous);
        }
    }

    public static void checkSideEffectAllowed(@NotNull EffectType effectType) {
        if (!SideEffectGuardImpl.isAllowed(effectType)) {
            throw new SideEffectNotAllowedException(effectType);
        }
    }

    public static enum EffectType {
        PROJECT_MODEL,
        SETTINGS,
        EXEC,
        INVOKE_LATER;

    }

    public static final class SideEffectNotAllowedException
    extends IllegalStateException
    implements ControlFlowException {
        public SideEffectNotAllowedException(@NotNull EffectType effectType) {
            super("Side effect not allowed: " + effectType.name());
        }
    }
}

