/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.DelegatingPointer;
import com.intellij.model.DelegatingPointerEq;
import com.intellij.model.HardPointerEq;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface Pointer<T> {
    @Nullable
    public T dereference();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> hardPointer(@NotNull T value) {
        return () -> value;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Function<? super U, ? extends T> restoration) {
        return new DelegatingPointer.ByValue<T, U>(underlyingPointer, restoration);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> uroborosPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
        return new DelegatingPointer.ByValueAndPointer<T, U>(underlyingPointer, restoration);
    }

    @Deprecated
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> hardPointerWithEquality(@NotNull T value) {
        return new HardPointerEq<T>(value);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Object key, @NotNull Function<? super U, ? extends T> restoration) {
        return new DelegatingPointerEq.ByValue<T, U>(underlyingPointer, key, restoration);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> uroborosPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Object key, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
        return new DelegatingPointerEq.ByValueAndPointer<T, U>(underlyingPointer, key, restoration);
    }
}

