/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.BranchService;
import com.intellij.model.BranchableSyntheticPsiElement;
import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ModelBranch
extends UserDataHolder {
    @NotNull
    public Project getProject();

    @NotNull
    public static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<? super ModelBranch> action) {
        return BranchService.getInstance().performInBranch(project, action);
    }

    @NotNull
    public VirtualFile findFileCopy(@NotNull VirtualFile var1);

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T var1);

    @NotNull
    public <T extends PsiReference> T obtainReferenceCopy(@NotNull T var1);

    @Nullable
    public VirtualFile findFileByUrl(@NotNull String var1);

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T var1);

    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile var1);

    @Nullable
    public static ModelBranch getPsiBranch(@NotNull PsiElement element) {
        if (element instanceof PsiDirectory) {
            return ModelBranch.getFileBranch(((PsiDirectory)element).getVirtualFile());
        }
        if (element instanceof BranchableSyntheticPsiElement) {
            return ((BranchableSyntheticPsiElement)element).getModelBranch();
        }
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        return psiFile == null ? null : ModelBranch.getFileBranch(psiFile.getViewProvider().getVirtualFile());
    }

    @Nullable
    public static ModelBranch getFileBranch(@NotNull VirtualFile file2) {
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        return file2 instanceof BranchedVirtualFile ? ((BranchedVirtualFile)file2).getBranch() : null;
    }

    public long getBranchedPsiModificationCount();

    public long getBranchedVfsStructureModificationCount();

    public void runAfterMerge(@NotNull Runnable var1);
}

