/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.Pointer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DelegatingPointer<T, U>
implements Pointer<T> {
    @NotNull
    private final Pointer<? extends U> myUnderlyingPointer;

    protected DelegatingPointer(@NotNull Pointer<? extends U> underlyingPointer) {
        this.myUnderlyingPointer = underlyingPointer;
    }

    @Override
    @Nullable
    public final T dereference() {
        U underlyingValue = this.myUnderlyingPointer.dereference();
        return underlyingValue == null ? null : (T)this.dereference(underlyingValue);
    }

    protected abstract T dereference(@NotNull U var1);

    static final class ByValueAndPointer<T, U>
    extends DelegatingPointer<T, U> {
        @NotNull
        private final BiFunction<? super U, ? super Pointer<T>, ? extends T> myRestoration;

        ByValueAndPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
            super(underlyingPointer);
            this.myRestoration = restoration;
        }

        @Override
        protected T dereference(@NotNull U underlyingValue) {
            return this.myRestoration.apply((ByValueAndPointer)underlyingValue, this);
        }
    }

    static final class ByValue<T, U>
    extends DelegatingPointer<T, U> {
        @NotNull
        private final Function<? super U, ? extends T> myRestoration;

        ByValue(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Function<? super U, ? extends T> restoration) {
            super(underlyingPointer);
            this.myRestoration = restoration;
        }

        @Override
        protected T dereference(@NotNull U underlyingValue) {
            return this.myRestoration.apply(underlyingValue);
        }
    }
}

