/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface BranchableUsageInfo {
    @NotNull
    public UsageInfo obtainBranchCopy(@NotNull ModelBranch var1);

    public static UsageInfo @NotNull [] convertUsages(UsageInfo @NotNull [] usages, @NotNull ModelBranch branch) {
        HashSet<String> unsupportedTypes = null;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(usages.length);
        for (UsageInfo t : usages) {
            if (t instanceof BranchableUsageInfo) {
                result.add(((BranchableUsageInfo)((Object)t)).obtainBranchCopy(branch));
                continue;
            }
            if (unsupportedTypes == null) {
                unsupportedTypes = new HashSet<String>();
            }
            unsupportedTypes.add(t.getClass().getName());
        }
        if (unsupportedTypes != null) {
            Logger.getInstance(BranchableUsageInfo.class).error("Branching is requested for " + String.join((CharSequence)", ", unsupportedTypes) + " class(es). Please implement BranchableUsageInfo interface");
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }
}

