/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface TokenList {
    public int getTokenCount();

    @NotNull
    public CharSequence getTokenizedText();

    public int getTokenStart(int var1);

    public int getTokenEnd(int var1);

    @NotNull
    default public TextRange getTokenRange(int index) {
        return new TextRange(this.getTokenStart(index), this.getTokenEnd(index));
    }

    public IElementType getTokenType(int var1);

    default public CharSequence getTokenText(int index) {
        if (index < 0 || index >= this.getTokenCount()) {
            return null;
        }
        return this.getTokenizedText().subSequence(this.getTokenStart(index), this.getTokenEnd(index));
    }

    default public boolean hasType(int index, @NotNull IElementType type) {
        return this.getTokenType(index) == type;
    }

    default public boolean hasType(int index, IElementType ... types) {
        return ArrayUtil.contains(this.getTokenType(index), types);
    }

    default public boolean hasType(int index, @NotNull TokenSet types) {
        return types.contains(this.getTokenType(index));
    }

    default public int backWithBraceMatching(int index, @NotNull IElementType opening, @NotNull IElementType closing) {
        if (this.getTokenType(index) == closing) {
            int nesting = 1;
            while (nesting > 0 && index > 0) {
                IElementType type;
                if ((type = this.getTokenType(--index)) == closing) {
                    ++nesting;
                    continue;
                }
                if (type != opening) continue;
                --nesting;
            }
        }
        return index - 1;
    }

    default public int backWhile(int index, @NotNull TokenSet toSkip) {
        while (this.hasType(index, toSkip)) {
            --index;
        }
        return index;
    }

    default public int forwardWhile(int index, @NotNull TokenSet toSkip) {
        while (this.hasType(index, toSkip)) {
            ++index;
        }
        return index;
    }

    @NotNull
    default public Lexer asLexer() {
        return new WrappingLexer(this);
    }

    public static class WrappingLexer
    extends LexerBase {
        private final TokenList myTokens;
        private int myIndex;

        WrappingLexer(TokenList tokens) {
            this.myTokens = tokens;
        }

        public TokenList getTokens() {
            return this.myTokens;
        }

        @Override
        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            assert (Comparing.equal((CharSequence)buffer, (CharSequence)this.myTokens.getTokenizedText()));
            assert (startOffset == 0);
            assert (endOffset == buffer.length());
            assert (initialState == 0);
            this.myIndex = 0;
        }

        @Override
        public int getState() {
            return this.myIndex;
        }

        @Override
        @Nullable
        public IElementType getTokenType() {
            return this.myTokens.getTokenType(this.myIndex);
        }

        @Override
        public int getTokenStart() {
            return this.myTokens.getTokenStart(this.myIndex);
        }

        @Override
        public int getTokenEnd() {
            return this.myTokens.getTokenEnd(this.myIndex);
        }

        @Override
        public void advance() {
            ++this.myIndex;
        }

        @Override
        @NotNull
        public CharSequence getBufferSequence() {
            return this.myTokens.getTokenizedText();
        }

        @Override
        public int getBufferEnd() {
            return this.myTokens.getTokenizedText().length();
        }
    }
}

