/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageMatcher;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.NotNull;

final class MetaLanguageKindMatcher
extends LanguageMatcher {
    @NotNull
    private final MetaLanguage myLanguage;

    MetaLanguageKindMatcher(@NotNull MetaLanguage language) {
        this.myLanguage = language;
    }

    @Override
    public boolean matchesLanguage(@NotNull Language language) {
        return LanguageUtil.getBaseLanguages(language).filter((Condition<Language>)((Condition)it -> this.myLanguage.matchesLanguage((Language)it))).isNotEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaLanguageKindMatcher matcher = (MetaLanguageKindMatcher)o;
        return this.myLanguage.equals(matcher.myLanguage);
    }

    public int hashCode() {
        return this.myLanguage.hashCode();
    }

    public String toString() {
        return this.myLanguage + " (meta) with dialects";
    }
}

