/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<Collection<MetaLanguage>> MATCHING_LANGUAGES = Key.create("language.matching");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file2) {
        return LanguageUtil.getLanguageForPsi(project, file2, null);
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file2, @Nullable FileType fileType) {
        Language fileLanguage;
        Language explicit;
        if (file2 == null) {
            return null;
        }
        Language language = explicit = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        Language language2 = explicit != null ? explicit : (fileLanguage = LanguageUtil.getFileTypeLanguage(fileType != null ? fileType : file2.getFileType()));
        if (fileLanguage == null) {
            return null;
        }
        for (LanguageSubstitutor substitutor : LanguageSubstitutors.getInstance().forKey(Language.ANY)) {
            Language language3 = substitutor.getLanguage(file2, project);
            if (language3 == null || language3 == Language.ANY) continue;
            fileLanguage = language3;
            break;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(fileLanguage, file2, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Language l = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file2.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@NotNull FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    @NotNull
    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(@NotNull ASTNode left, @NotNull ASTNode right, @NotNull Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        HashSet<Language> result = new HashSet<Language>();
        LanguageUtil.getAllDerivedLanguages(base, result);
        return result;
    }

    private static void getAllDerivedLanguages(@NotNull Language base, @NotNull Set<? super Language> result) {
        result.add(base);
        for (Language dialect : base.getDialects()) {
            LanguageUtil.getAllDerivedLanguages(dialect, result);
        }
    }

    public static boolean isInTemplateLanguageFile(@NotNull PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    @NotNull
    public static List<Language> getInjectableLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isInjectableLanguage(lang));
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        return type != null && !StringUtil.isEmpty(type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isFileLanguage(lang));
    }

    @NotNull
    public static List<Language> getLanguages(@NotNull Predicate<? super Language> filter) {
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!filter.test(language)) continue;
            result.add(language);
        }
        result.sort(LANGUAGE_COMPARATOR);
        return result;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile = element.getContainingFile();
        FileViewProvider provider = containingFile.getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() > 1 && languages.contains(language = containingFile.getLanguage())) {
            return language;
        }
        return provider.getBaseLanguage();
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        Set result;
        Collection<MetaLanguage> cached = language.getUserData(MATCHING_LANGUAGES);
        if (cached != null) {
            return cached;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            return Collections.emptyList();
        }
        if (language instanceof MetaLanguage) {
            result = Collections.emptySet();
        } else {
            result = new HashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(metaLanguage -> {
                if (metaLanguage.matchesLanguage(language)) {
                    result.add(metaLanguage);
                }
            });
        }
        return language.putUserDataIfAbsent(MATCHING_LANGUAGES, result);
    }

    static void clearMatchingMetaLanguages(@NotNull Language language) {
        language.putUserData(MATCHING_LANGUAGES, null);
    }

    @NotNull
    public static JBIterable<Language> getBaseLanguages(@NotNull Language language) {
        return JBIterable.generate(language, Language::getBaseLanguage);
    }
}

