/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ExactMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageKindMatcher;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.MetaLanguageKindMatcher;
import com.intellij.lang.MetaLanguageMatcher;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class LanguageMatcher {
    LanguageMatcher() {
    }

    public abstract boolean matchesLanguage(@NotNull Language var1);

    @Contract(pure=true)
    @NotNull
    public static LanguageMatcher match(@NotNull Language language) {
        if (language instanceof MetaLanguage) {
            return new MetaLanguageMatcher((MetaLanguage)language);
        }
        return new ExactMatcher(language);
    }

    @Contract(pure=true)
    @NotNull
    public static LanguageMatcher matchWithDialects(@NotNull Language language) {
        if (language instanceof MetaLanguage) {
            return new MetaLanguageKindMatcher((MetaLanguage)language);
        }
        return new LanguageKindMatcher(language);
    }
}

