/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = new ConcurrentHashMap<Class<? extends Language>, Language>();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = new ConcurrentHashMap<String, List<Language>>();
    private static final Map<String, Language> ourRegisteredIDs = new ConcurrentHashMap<String, Language>();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NonNls @NotNull String ID2) {
        this(ID2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected Language(@NonNls @NotNull String ID2, String ... mimeTypes) {
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NonNls @NotNull String ID2, String ... mimeTypes) {
        if (baseLanguage instanceof MetaLanguage) {
            throw new ImplementationConflictException("MetaLanguage cannot be a base language.\nThis language: '" + ID2 + "'\nBase language: '" + baseLanguage.getID() + "'", null, this, baseLanguage);
        }
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.putIfAbsent(langClass, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language of '" + langClass + "' is already registered: " + prev, null, prev, this);
        }
        prev = ourRegisteredIDs.putIfAbsent(ID2, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language with ID '" + ID2 + "' is already registered: " + prev.getClass(), null, prev, this);
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty(mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, mimeType, ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        return Collections.unmodifiableCollection(new ArrayList<Language>(languages));
    }

    @ApiStatus.Internal
    public static void unregisterAllLanguagesIn(@NotNull ClassLoader classLoader, @NotNull PluginDescriptor pluginDescriptor) {
        for (Map.Entry<Class<? extends Language>, Language> e : new ArrayList<Map.Entry<Class<? extends Language>, Language>>(ourRegisteredLanguages.entrySet())) {
            Class<? extends Language> clazz = e.getKey();
            Language language = e.getValue();
            if (clazz.getClassLoader() != classLoader) continue;
            language.unregisterLanguage(pluginDescriptor);
        }
        IElementType.unregisterElementTypes(classLoader, pluginDescriptor);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void unregisterLanguage(@NotNull Language language) {
        PluginException.reportDeprecatedUsage("this method", "");
        language.unregisterLanguage(new DefaultPluginDescriptor("unknown"));
    }

    @ApiStatus.Internal
    public void unregisterLanguage(@NotNull PluginDescriptor pluginDescriptor) {
        IElementType.unregisterElementTypes(this, pluginDescriptor);
        ReferenceProvidersRegistry referenceProvidersRegistry = ApplicationManager.getApplication().getServiceIfCreated(ReferenceProvidersRegistry.class);
        if (referenceProvidersRegistry != null) {
            referenceProvidersRegistry.unloadProvidersFor(this);
        }
        ourRegisteredLanguages.remove(this.getClass());
        ourRegisteredIDs.remove(this.getID());
        for (String mimeType : this.getMimeTypes()) {
            ourRegisteredMimeTypes.remove(mimeType);
        }
        Language baseLanguage = this.getBaseLanguage();
        if (baseLanguage != null) {
            baseLanguage.unregisterDialect(this);
        }
    }

    @ApiStatus.Internal
    public void unregisterDialect(@NotNull Language language) {
        this.myDialects.remove(language);
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        return (T)ourRegisteredLanguages.get(klass);
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
    }

    @Override
    public String toString() {
        return "Language: " + this.myID;
    }

    public String @NotNull [] getMimeTypes() {
        return this.myMimeTypes;
    }

    @NotNull
    @NlsSafe
    public String getID() {
        return this.myID;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        return FileTypeRegistry.getInstance().findFileTypeByLanguage(this);
    }

    @ApiStatus.Internal
    @Nullable
    public LanguageFileType findMyFileType(FileType @NotNull [] types) {
        LanguageFileType languageFileType;
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || (languageFileType = (LanguageFileType)fileType).getLanguage() != this || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf((languageFileType = (LanguageFileType)fileType).getLanguage()) || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    @Contract(pure=true)
    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull @NonNls String anotherLanguageId) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        return this.myDialects;
    }

    @Nullable
    public static Language findLanguageByID(@NonNls String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(@NotNull String ID2, boolean register) {
        Language language = Language.findLanguageByID(ID2);
        if (language != null) {
            throw new IllegalArgumentException("Language with ID=" + ID2 + " already registered: " + language + "; " + language.getClass());
        }
        this.myID = ID2;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }
}

