/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.CastableArgument;
import com.intellij.execution.rmi.RemoteCastable;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.ServerError;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteUtil {
    private static final ConcurrentMap<Couple<Class<?>>, Map<Method, Method>> ourRemoteToLocalMap = ConcurrentFactoryMap.createMap(key -> {
        HashMap<Method, Method> map = new HashMap<Method, Method>();
        for (Method method : ((Class)key.second).getMethods()) {
            Method m = null;
            block1: for (Method candidate : ((Class)key.first).getMethods()) {
                if (candidate.getParameterCount() != method.getParameterCount() || !candidate.getName().equals(method.getName())) continue;
                Class<?>[] cpts = candidate.getParameterTypes();
                Class<?>[] mpts = method.getParameterTypes();
                for (int i = 0; i < mpts.length; ++i) {
                    Class<?> mpt = mpts[i];
                    Class<?> cpt = RemoteUtil.castArgumentClassToLocal(cpts[i]);
                    if (!cpt.isAssignableFrom(mpt)) continue block1;
                }
                m = candidate;
                break;
            }
            if (m == null) continue;
            map.put(method, m);
        }
        return map;
    });

    RemoteUtil() {
    }

    @NotNull
    public static <T> T castToRemoteNotNull(Object object, Class<T> clazz) {
        return Objects.requireNonNull(RemoteUtil.castToRemote(object, clazz));
    }

    @Nullable
    public static <T> T castToRemote(@Nullable Object object, @NotNull Class<T> clazz) {
        RemoteInvocationHandler rih;
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (handler instanceof RemoteInvocationHandler && clazz.isInstance((rih = (RemoteInvocationHandler)handler).myRemote)) {
            return (T)rih.myRemote;
        }
        return null;
    }

    @NotNull
    public static <T> T castToLocal(@Nullable Object remote, @NotNull Class<T> clazz) {
        if (clazz.isInstance(remote)) {
            return (T)remote;
        }
        ClassLoader loader = clazz.getClassLoader();
        return (T)Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(remote, clazz, loader));
    }

    private static Class<?> tryFixReturnType(Object result, Class<?> returnType, ClassLoader loader) throws Exception {
        if (returnType.isInterface()) {
            return returnType;
        }
        if (result instanceof RemoteCastable) {
            String className = ((RemoteCastable)result).getCastToClassName();
            return Class.forName(className, true, loader);
        }
        return returnType;
    }

    private static Class<?> castArgumentClassToLocal(@NotNull Class<?> remote) {
        try {
            Type[] generics;
            if (!CastableArgument.class.isAssignableFrom(remote)) {
                return remote;
            }
            for (Type generic : generics = remote.getGenericInterfaces()) {
                Type rawType;
                if (!(generic instanceof ParameterizedType) || (rawType = ((ParameterizedType)generic).getRawType()) != CastableArgument.class) continue;
                return (Class)((ParameterizedType)generic).getActualTypeArguments()[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return remote;
    }

    private static Object @Nullable [] fixArgs(Object @Nullable [] args2, @NotNull Method method) {
        if (args2 == null) {
            return null;
        }
        if (method.getParameterCount() != args2.length) {
            return args2;
        }
        Object[] result = new Object[args2.length];
        try {
            Class<?>[] methodArgs = method.getParameterTypes();
            for (int i = 0; i < args2.length; ++i) {
                result[i] = RemoteUtil.fixArg(args2[i], methodArgs[i]);
            }
        }
        catch (Exception e) {
            return args2;
        }
        return result;
    }

    @Nullable
    private static Object fixArg(@Nullable Object arg2, @NotNull Class<?> fieldClass) {
        if (arg2 == null) {
            return null;
        }
        if (!fieldClass.isPrimitive() && Proxy.isProxyClass(arg2.getClass())) {
            boolean isCastableArg;
            InvocationHandler handler = Proxy.getInvocationHandler(arg2);
            RemoteInvocationHandler remoteHandler = ObjectUtils.tryCast(handler, RemoteInvocationHandler.class);
            boolean bl = isCastableArg = remoteHandler != null && CastableArgument.class.isAssignableFrom(remoteHandler.myRemote.getClass());
            if (isCastableArg && remoteHandler.myClazz == fieldClass) {
                return remoteHandler.myRemote;
            }
        }
        return arg2;
    }

    public static <T> T substituteClassLoader(final @NotNull T remote, final @Nullable ClassLoader classLoader) throws Exception {
        return RemoteUtil.executeWithClassLoader(() -> {
            Object proxy = Proxy.newProxyInstance(classLoader, remote.getClass().getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                    return RemoteUtil.executeWithClassLoader(() -> RemoteUtil.invokeRemote(method, method, remote, args2, classLoader, true), classLoader);
                }
            });
            return proxy;
        }, classLoader);
    }

    private static Object invokeRemote(@NotNull Method localMethod, @NotNull Method remoteMethod, @NotNull Object remoteObj, Object @Nullable [] args2, @Nullable ClassLoader loader, boolean substituteClassLoader) throws Exception {
        boolean canThrowError = false;
        try {
            Object result = remoteMethod.invoke(remoteObj, args2);
            canThrowError = true;
            return RemoteUtil.handleRemoteResult(result, localMethod.getReturnType(), loader, substituteClassLoader);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerError) {
                cause = ObjectUtils.chooseNotNull(cause.getCause(), cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (canThrowError && cause instanceof Error || cause instanceof LinkageError) {
                throw (Error)cause;
            }
            if (cause instanceof Exception && RemoteUtil.canThrow(cause, localMethod)) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <T> T handleRemoteResult(Object value, Class<? super T> clazz, Object requestor) throws Exception {
        return RemoteUtil.handleRemoteResult(value, clazz, requestor.getClass().getClassLoader(), false);
    }

    private static <T> T handleRemoteResult(Object value, Class<?> methodReturnType, ClassLoader classLoader, boolean substituteClassLoader) throws Exception {
        Object result;
        if (value instanceof Remote) {
            result = value instanceof RemoteCastable ? RemoteUtil.castToLocal(value, RemoteUtil.tryFixReturnType(value, methodReturnType, classLoader)) : (substituteClassLoader ? RemoteUtil.substituteClassLoader(value, classLoader) : value);
        } else if (value instanceof List && methodReturnType.isInterface()) {
            result = Arrays.asList((Object[])RemoteUtil.handleRemoteResult(((List)value).toArray(), Object.class, classLoader, substituteClassLoader));
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                array[i] = RemoteUtil.handleRemoteResult(array[i], Object.class, classLoader, substituteClassLoader);
            }
            result = array;
        } else {
            result = value;
        }
        return (T)result;
    }

    private static boolean canThrow(@NotNull Throwable cause, @NotNull Method method) {
        for (Class<?> each : method.getExceptionTypes()) {
            if (!each.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    public static <T> T executeWithClassLoader(ThrowableComputable<T, ? extends Exception> action, ClassLoader classLoader) throws Exception {
        return ClassLoaderUtil.computeWithClassLoader(classLoader, action);
    }

    @NotNull
    public static Throwable unwrap(@NotNull Throwable e) {
        for (Throwable candidate = e; candidate != null; candidate = candidate.getCause()) {
            Class<?> clazz = candidate.getClass();
            if (clazz == InvocationTargetException.class || clazz == UndeclaredThrowableException.class) continue;
            return candidate;
        }
        return e;
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Object myRemote;
        private final Class<?> myClazz;
        private final ClassLoader myLoader;

        RemoteInvocationHandler(Object remote, Class<?> clazz, ClassLoader loader) {
            this.myRemote = remote;
            this.myClazz = clazz;
            this.myLoader = loader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if ("equals".equals(method.getName())) {
                    return proxy == args2[0];
                }
                if ("hashCode".equals(method.getName())) {
                    return this.hashCode();
                }
                return method.invoke(this.myRemote, args2);
            }
            Method remoteMethod = (Method)((Map)ourRemoteToLocalMap.get(Couple.of(this.myRemote.getClass(), this.myClazz))).get(method);
            if (remoteMethod == null) {
                throw new NoSuchMethodError(method.getName() + " in " + this.myRemote.getClass());
            }
            return RemoteUtil.invokeRemote(method, remoteMethod, this.myRemote, RemoteUtil.fixArgs(args2, method), this.myLoader, false);
        }
    }
}

