/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static final ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    private final int myParentPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args2) {
        this(pid, commandLine, executableName, args2, null, -1);
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args2, @Nullable String executablePath) {
        this(pid, commandLine, executableName, args2, executablePath, -1);
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args2, @Nullable String executablePath, int parentPid) {
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty(executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args2;
        this.myParentPid = parentPid;
    }

    public int getPid() {
        return this.myPid;
    }

    public int getParentPid() {
        return this.myParentPid;
    }

    @NotNull
    @NlsSafe
    public String getCommandLine() {
        return this.myCommandLine;
    }

    @NotNull
    @NlsSafe
    public String getExecutableName() {
        return this.myExecutableName;
    }

    @NotNull
    @NlsSafe
    public Optional<String> getExecutableCannonicalPath() {
        return this.myExecutablePath.map(s -> {
            try {
                return new File((String)s).getCanonicalPath();
            }
            catch (IOException e) {
                return s;
            }
        });
    }

    @NotNull
    @NlsSafe
    public String getExecutableDisplayName() {
        return StringUtil.trimEnd(this.myExecutableName, ".exe", true);
    }

    @NotNull
    @NlsSafe
    public String getArgs() {
        return this.myArgs;
    }

    public String toString() {
        return this.myPid + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'" + this.myExecutablePath.map(s -> " " + s).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        if (!this.myCommandLine.equals(info.myCommandLine)) {
            return false;
        }
        if (!this.myExecutablePath.equals(info.myExecutablePath)) {
            return false;
        }
        return this.myParentPid == info.myParentPid;
    }

    public int hashCode() {
        int result = this.myPid;
        result = 31 * result + this.myExecutableName.hashCode();
        result = 31 * result + this.myArgs.hashCode();
        result = 31 * result + this.myCommandLine.hashCode();
        result = 31 * result + this.myParentPid;
        return result;
    }
}

