/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CapturingProcessRunner {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CapturingProcessRunner.class);
    @NotNull
    private final ProcessOutput myOutput = new ProcessOutput();
    @NotNull
    private final ProcessHandler myProcessHandler;

    public CapturingProcessRunner(@NotNull BaseProcessHandler<?> processHandler) {
        this((ProcessHandler)processHandler);
    }

    public CapturingProcessRunner(@NotNull BaseProcessHandler<?> processHandler, @NotNull Function<? super ProcessOutput, ? extends ProcessAdapter> processAdapterProducer) {
        this((ProcessHandler)processHandler, processAdapterProducer);
    }

    public CapturingProcessRunner(@NotNull ProcessHandler processHandler) {
        this(processHandler, (? super ProcessOutput processOutput) -> new CapturingProcessAdapter((ProcessOutput)processOutput));
    }

    public CapturingProcessRunner(@NotNull ProcessHandler processHandler, @NotNull Function<? super ProcessOutput, ? extends ProcessAdapter> processAdapterProducer) {
        this.myProcessHandler = processHandler;
        this.myProcessHandler.addProcessListener(processAdapterProducer.apply(this.myOutput));
    }

    @NotNull
    public ProcessOutput runProcess() {
        this.myProcessHandler.startNotify();
        if (this.myProcessHandler.waitFor()) {
            this.setErrorCodeIfNotYetSet();
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        return this.myOutput;
    }

    @NotNull
    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.runProcess(timeoutInMilliseconds, true);
    }

    @NotNull
    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            return this.runProcess();
        }
        this.myProcessHandler.startNotify();
        if (this.myProcessHandler.waitFor(timeoutInMilliseconds)) {
            this.setErrorCodeIfNotYetSet();
        } else {
            if (destroyOnTimeout) {
                this.myProcessHandler.destroyProcess();
            }
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator) {
        return this.runProcess(indicator, -1);
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        return this.runProcess(indicator, timeoutInMilliseconds, true);
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            timeoutInMilliseconds = Integer.MAX_VALUE;
        }
        int WAIT_INTERVAL = 10;
        int waitingTime = 0;
        boolean setExitCode2 = true;
        this.myProcessHandler.startNotify();
        while (!this.myProcessHandler.waitFor(10L)) {
            boolean destroying;
            boolean timeout = (waitingTime += 10) >= timeoutInMilliseconds;
            boolean canceled = indicator.isCanceled();
            if (!canceled && !timeout) continue;
            setExitCode2 = destroying = canceled || destroyOnTimeout;
            if (destroying && !this.myProcessHandler.isProcessTerminating() && !this.myProcessHandler.isProcessTerminated()) {
                this.myProcessHandler.destroyProcess();
            }
            if (canceled) {
                this.myOutput.setCancelled();
                break;
            }
            this.myOutput.setTimeout();
            break;
        }
        if (setExitCode2) {
            if (this.myProcessHandler.waitFor()) {
                this.setErrorCodeIfNotYetSet();
            } else {
                LOG.info("runProcess: exit value unavailable");
            }
        }
        return this.myOutput;
    }

    private void setErrorCodeIfNotYetSet() {
        if (!this.myOutput.isExitCodeSet() && this.myProcessHandler instanceof BaseProcessHandler) {
            this.myOutput.setExitCode(((Process)((BaseProcessHandler)this.myProcessHandler).getProcess()).exitValue());
        }
    }
}

