/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseOSProcessHandler
extends BaseProcessHandler<Process> {
    private static final Logger LOG = Logger.getInstance(BaseOSProcessHandler.class);
    private final AtomicLong mySleepStart = new AtomicLong(System.currentTimeMillis());
    private final Throwable myProcessStart = new Throwable("Process creation:");

    public BaseOSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        super(process, commandLine, charset);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        return ProcessIOExecutorService.INSTANCE.submit(task);
    }

    @Override
    @NotNull
    public Future<?> executeTask(@NotNull Runnable task) {
        return this.executeOnPooledThread(task);
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        if (Boolean.getBoolean("output.reader.blocking.mode")) {
            return BaseOutputReader.Options.BLOCKING;
        }
        return BaseOutputReader.Options.NON_BLOCKING;
    }

    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(@NotNull ProcessEvent event) {
                try {
                    BaseDataReader stdOutReader = BaseOSProcessHandler.this.createOutputDataReader();
                    BaseDataReader stdErrReader = BaseOSProcessHandler.this.processHasSeparateErrorStream() ? BaseOSProcessHandler.this.createErrorDataReader() : null;
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback((Consumer<? super Integer>)((Consumer)exitCode -> {
                        try {
                            if (stdErrReader != null) {
                                stdErrReader.stop();
                            }
                            stdOutReader.stop();
                            try {
                                if (stdErrReader != null) {
                                    stdErrReader.waitFor();
                                }
                                stdOutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            BaseOSProcessHandler.this.onOSProcessTerminated((int)exitCode);
                        }
                    }));
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }
        });
        super.startNotify();
    }

    @NotNull
    protected BaseDataReader createErrorDataReader() {
        return new SimpleOutputReader(this.createProcessErrReader(), ProcessOutputTypes.STDERR, this.readerOptions(), "error stream of " + this.myPresentableName);
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        return new SimpleOutputReader(this.createProcessOutReader(), ProcessOutputTypes.STDOUT, this.readerOptions(), "output stream of " + this.myPresentableName);
    }

    @NotNull
    protected Reader createProcessOutReader() {
        return this.createInputStreamReader(this.myProcess.getInputStream());
    }

    @NotNull
    protected Reader createProcessErrReader() {
        return this.createInputStreamReader(this.myProcess.getErrorStream());
    }

    @NotNull
    private Reader createInputStreamReader(@NotNull InputStream streamToRead) {
        Charset charset = this.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return new BaseInputStreamReader(streamToRead, charset);
    }

    @Override
    public String toString() {
        return this.myCommandLine;
    }

    @Override
    public boolean waitFor() {
        boolean result = super.waitFor();
        try {
            this.myWaitFor.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean waitFor(long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        boolean result = super.waitFor(timeoutInMilliseconds);
        long elapsed = System.currentTimeMillis() - start;
        try {
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result &= this.myWaitFor.waitFor(Math.max(0L, timeoutInMilliseconds - elapsed), TimeUnit.MILLISECONDS);
    }

    protected class SimpleOutputReader
    extends BaseOutputReader {
        private final Key<?> myProcessOutputType;

        public SimpleOutputReader(Reader reader, Key<?> outputType, @NotNull @NonNls BaseOutputReader.Options options, String presentableName) {
            super(reader, options);
            this.myProcessOutputType = outputType;
            this.start(presentableName);
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return BaseOSProcessHandler.this.executeTask(runnable);
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            BaseOSProcessHandler.this.notifyTextAvailable(text, this.myProcessOutputType);
        }

        @Override
        protected void beforeSleeping(boolean hasJustReadSomething) {
            long sleepStart = BaseOSProcessHandler.this.mySleepStart.get();
            if (sleepStart < 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            if (hasJustReadSomething) {
                BaseOSProcessHandler.this.mySleepStart.set(now);
            } else if (TimeUnit.MILLISECONDS.toMinutes(now - sleepStart) >= 2L && BaseOSProcessHandler.this.mySleepStart.compareAndSet(sleepStart, -1L)) {
                LOG.warn("Process hasn't generated any output for a long time.\nIf it's a long-running mostly idle daemon process, consider overriding OSProcessHandler#readerOptions with 'BaseOutputReader.Options.forMostlySilentProcess()' to reduce CPU usage.\nCommand line: " + StringUtil.trimLog(StringUtil.notNullize(BaseOSProcessHandler.this.myCommandLine), 1000), BaseOSProcessHandler.this.myProcessStart);
            }
        }
    }
}

