/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.AnsiStreamingLexer;
import com.intellij.execution.process.AnsiTerminalEmulator;
import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private final ColoredOutputTypeRegistry myColoredOutputTypeRegistry = ColoredOutputTypeRegistry.getInstance();
    private final AnsiStreamingLexer myStdoutLexer = new AnsiStreamingLexer();
    private final AnsiStreamingLexer myStderrLexer = new AnsiStreamingLexer();
    private final AnsiTerminalEmulator myStdoutEmulator = new AnsiTerminalEmulator();
    private final AnsiTerminalEmulator myStderrEmulator = new AnsiTerminalEmulator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        AnsiTerminalEmulator effectiveEmulator;
        AnsiStreamingLexer effectiveLexer;
        if (ProcessOutputType.isStdout(outputType)) {
            effectiveLexer = this.myStdoutLexer;
            effectiveEmulator = this.myStdoutEmulator;
        } else if (ProcessOutputType.isStderr(outputType)) {
            effectiveLexer = this.myStderrLexer;
            effectiveEmulator = this.myStderrEmulator;
        } else {
            this.processTextWithoutAnsi(text, outputType, textAcceptor);
            return;
        }
        List<Pair<String, Key>> chunks = null;
        AnsiStreamingLexer ansiStreamingLexer = effectiveLexer;
        synchronized (ansiStreamingLexer) {
            AnsiStreamingLexer.AnsiElementType elementType;
            effectiveLexer.append(text);
            effectiveLexer.advance();
            while ((elementType = effectiveLexer.getElementType()) != null) {
                String elementText = effectiveLexer.getElementTextSmart();
                assert (elementText != null);
                if (elementType == AnsiStreamingLexer.SGR) {
                    effectiveEmulator.processSgr(elementText);
                } else if (elementType == AnsiStreamingLexer.TEXT) {
                    chunks = this.processTextChunk(chunks, elementText, outputType, textAcceptor);
                } else assert (elementType == AnsiStreamingLexer.CONTROL);
                effectiveLexer.advance();
            }
        }
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private void processTextWithoutAnsi(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        List<Pair<String, Key>> chunks = this.processTextChunk(null, text, outputType, textAcceptor);
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = new ArrayList<Pair<String, Key>>(1);
            }
            buffer.add((Pair<String, Key>)Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (ProcessOutputType.isStdout(outputType)) {
            return this.myStdoutEmulator.isInitialState() ? outputType : this.myColoredOutputTypeRegistry.getOutputType(this.myStdoutEmulator, outputType);
        }
        if (ProcessOutputType.isStderr(outputType)) {
            return this.myStderrEmulator.isInitialState() ? outputType : this.myColoredOutputTypeRegistry.getOutputType(this.myStderrEmulator, outputType);
        }
        return outputType;
    }

    @FunctionalInterface
    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(@NotNull String var1, @NotNull Key var2);
    }

    @Deprecated(forRemoval=true)
    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> var1);
    }
}

