/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance(PtyCommandLine.class);
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    public static final int MAX_COLUMNS = 2500;
    private final LocalPtyOptions.Builder myOptionsBuilder = LocalPtyOptions.DEFAULT.builder().consoleMode(true).useWinConPty(LocalPtyOptions.shouldUseWinConPty());
    private boolean myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
    private boolean myUnixOpenTtyToPreserveOutputAfterTermination = true;

    public static boolean isEnabled() {
        return Registry.is(RUN_PROCESSES_WITH_PTY);
    }

    public PtyCommandLine() {
    }

    public PtyCommandLine withUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myOptionsBuilder.useCygwinLaunch(useCygwinLaunch);
        return this;
    }

    public PtyCommandLine withConsoleMode(boolean consoleMode) {
        this.myOptionsBuilder.consoleMode(consoleMode);
        return this;
    }

    public boolean isConsoleMode() {
        return this.myOptionsBuilder.consoleMode();
    }

    public PtyCommandLine withInitialColumns(int initialColumns) {
        this.myOptionsBuilder.initialColumns(initialColumns);
        return this;
    }

    public PtyCommandLine withInitialRows(int initialRows) {
        this.myOptionsBuilder.initialRows(initialRows);
        return this;
    }

    public PtyCommandLine withOptions(@NotNull LocalPtyOptions options) {
        this.myOptionsBuilder.set(options);
        return this;
    }

    public PtyCommandLine(@NotNull List<String> command) {
        super(command);
    }

    public PtyCommandLine(@NotNull GeneralCommandLine original) {
        super(original);
        if (original instanceof PtyCommandLine) {
            this.myOptionsBuilder.set(((PtyCommandLine)original).myOptionsBuilder.build());
        }
    }

    @NotNull
    PtyCommandLine withWindowsAnsiColorDisabled() {
        this.myWindowsAnsiColorEnabled = false;
        return this;
    }

    @NotNull
    public PtyCommandLine withUnixOpenTtyToPreserveOutputAfterTermination(boolean unixOpenTtyToPreserveOutputAfterTermination) {
        this.myUnixOpenTtyToPreserveOutputAfterTermination = unixOpenTtyToPreserveOutputAfterTermination;
        return this;
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (this.getInputFile() == null) {
            try {
                return this.startProcessWithPty(commands);
            }
            catch (Throwable t) {
                String message = "Couldn't run process with PTY";
                if (LOG.isDebugEnabled()) {
                    String logFileContent = PtyCommandLine.loadLogFile();
                    if (logFileContent != null) {
                        LOG.debug(message, t, logFileContent);
                    } else {
                        LOG.warn(message, t);
                    }
                }
                LOG.warn(message, t);
            }
        }
        return super.startProcess(commands);
    }

    @Nullable
    private static String loadLogFile() {
        File logFile;
        Application app = ApplicationManager.getApplication();
        File file2 = logFile = app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
        if (logFile != null && logFile.exists()) {
            try {
                return FileUtil.loadFile(logFile);
            }
            catch (Exception e) {
                return "Unable to retrieve pty log: " + e.getMessage();
            }
        }
        return null;
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (!SystemInfo.isWindows && !this.getEnvironment().containsKey("TERM")) {
            env.put("TERM", "xterm-256color");
        }
        String[] command = ArrayUtilRt.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        LocalPtyOptions options = this.myOptionsBuilder.build();
        Application app = ApplicationManager.getApplication();
        return ProcessService.getInstance().startPtyProcess(command, directory, env, options, app, this.isRedirectErrorStream(), this.myWindowsAnsiColorEnabled, this.myUnixOpenTtyToPreserveOutputAfterTermination);
    }
}

