/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ParametersList
implements Cloneable {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)(?:=(.+))?");
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private final List<CompositeParameterTargetedValue> myParameters = new ArrayList<CompositeParameterTargetedValue>();
    private final List<ParamsGroup> myGroups = new SmartList<ParamsGroup>();
    private final NotNullLazyValue<Map<String, String>> myMacroMap = NotNullLazyValue.lazy(ParametersList::computeMacroMap);
    private static Map<String, String> ourTestMacros;

    public boolean hasParameter(@NotNull @NonNls String parameter) {
        return ContainerUtil.lastIndexOf(this.myParameters, value -> parameter.equals(value.getLocalValue())) != -1;
    }

    public boolean hasProperty(@NotNull @NonNls String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    @Nullable
    public String getPropertyValue(@NotNull @NonNls String propertyName) {
        String prefix;
        String exact = "-D" + propertyName;
        int index = this.indexOfLocalParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$getPropertyValue$1(exact, prefix = "-D" + propertyName + "=", arg_0)));
        if (index < 0) {
            return null;
        }
        String str = this.myParameters.get(index).getLocalValue();
        return str.length() == exact.length() ? "" : str.substring(prefix.length());
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.getProperties("");
    }

    @NotNull
    public Map<String, String> getProperties(@NonNls String valueIfMissing) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        JBIterable matchers = JBIterable.from(this.myParameters).map(CompositeParameterTargetedValue::getLocalValue).map(PROPERTY_PATTERN::matcher).filter(Matcher::matches);
        for (Matcher matcher : matchers) {
            result.put(matcher.group(1), StringUtil.notNullize(matcher.group(2), valueIfMissing));
        }
        return result;
    }

    @NotNull
    public String getParametersString() {
        return ParametersList.join(this.getList());
    }

    public String @NotNull [] getArray() {
        return ArrayUtilRt.toStringArray(this.getList());
    }

    @NotNull
    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            return Collections.unmodifiableList(this.getLocalParameters());
        }
        ArrayList<String> params = new ArrayList<String>(this.getLocalParameters());
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        return Collections.unmodifiableList(params);
    }

    @NotNull
    public List<CompositeParameterTargetedValue> getTargetedList() {
        if (this.myGroups.isEmpty()) {
            return Collections.unmodifiableList(this.myParameters);
        }
        ArrayList<CompositeParameterTargetedValue> params = new ArrayList<CompositeParameterTargetedValue>(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(CompositeParameterTargetedValue.targetizeParameters(group.getParameters()));
        }
        return Collections.unmodifiableList(params);
    }

    @NotNull
    private List<String> getLocalParameters() {
        return ContainerUtil.map(this.myParameters, CompositeParameterTargetedValue::getLocalValue);
    }

    @NotNull
    private CompositeParameterTargetedValue createExpandedLocalValue(String param) {
        return new CompositeParameterTargetedValue(this.expandMacros(param));
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NotNull @NonNls String parameter) {
        this.addAt(0, parameter);
    }

    public void prepend(@Nullable CompositeParameterTargetedValue parameterTargetedValue) {
        this.myParameters.add(0, parameterTargetedValue);
    }

    public void prependAll(String ... parameter) {
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(@Nullable @NonNls String parameters) {
        if (StringUtil.isEmptyOrSpaces(parameters)) {
            return;
        }
        for (String param : ParametersList.parse(parameters)) {
            this.add(param);
        }
    }

    public void add(@Nullable @NonNls String parameter) {
        if (parameter == null) {
            return;
        }
        this.myParameters.add(this.createExpandedLocalValue(parameter));
    }

    public void add(@Nullable CompositeParameterTargetedValue parameterTargetedValue) {
        if (parameterTargetedValue == null) {
            return;
        }
        this.myParameters.add(parameterTargetedValue);
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull @NonNls String groupId) {
        return this.addParamsGroup(new ParamsGroup(groupId));
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull ParamsGroup group) {
        this.myGroups.add(group);
        return group;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull ParamsGroup group) {
        this.myGroups.add(index, group);
        return group;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull @NonNls String groupId) {
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index, group);
        return group;
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public List<String> getParameters() {
        return Collections.unmodifiableList(this.getLocalParameters());
    }

    @NotNull
    public List<ParamsGroup> getParamsGroups() {
        return Collections.unmodifiableList(this.myGroups);
    }

    @NotNull
    public ParamsGroup getParamsGroupAt(int index) {
        return this.myGroups.get(index);
    }

    @Nullable
    public ParamsGroup getParamsGroup(@NotNull @NonNls String name) {
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    @Nullable
    public ParamsGroup removeParamsGroup(int index) {
        return this.myGroups.remove(index);
    }

    public void addAt(int index, @NotNull @NonNls String parameter) {
        this.myParameters.add(index, this.createExpandedLocalValue(parameter));
    }

    public void defineSystemProperty(@NotNull @NonNls String propertyName) {
        this.defineProperty(propertyName, System.getProperty(propertyName));
    }

    public void defineProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        String prefix;
        if (propertyValue == null) {
            return;
        }
        @NlsSafe String exact = "-D" + propertyName;
        int index = this.indexOfLocalParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$defineProperty$2(exact, prefix = "-D" + propertyName + "=", arg_0)));
        if (index > -1) {
            return;
        }
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.myParameters.add(new CompositeParameterTargetedValue(value));
    }

    public void addProperty(@NotNull @NonNls String propertyName) {
        @NlsSafe String exact = "-D" + propertyName;
        @NlsSafe String prefix = "-D" + propertyName + "=";
        this.replaceOrAddAt(new CompositeParameterTargetedValue(exact), this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (propertyValue == null) {
            return;
        }
        @NlsSafe String exact = "-D" + propertyName;
        @NlsSafe String prefix = "-D" + propertyName + "=";
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.replaceOrAddAt(new CompositeParameterTargetedValue(value), this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addNotEmptyProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (StringUtil.isEmptyOrSpaces(propertyValue)) {
            return;
        }
        this.addProperty(propertyName, propertyValue);
    }

    public void replaceOrAppend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        this.replaceOrAddAt(this.createExpandedLocalValue(replacement), this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    public void replaceOrPrepend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        this.replaceOrAddAt(this.createExpandedLocalValue(replacement), 0, (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    private void replaceOrAddAt(@NotNull CompositeParameterTargetedValue replacement, int position, @NotNull Condition<? super String> existingCondition) {
        int index = this.indexOfLocalParameter(existingCondition);
        boolean setNewValue = StringUtil.isNotEmpty(replacement.getLocalValue());
        if (index > -1 && setNewValue) {
            this.myParameters.set(index, replacement);
        } else if (index > -1) {
            this.myParameters.remove(index);
        } else if (setNewValue) {
            this.myParameters.add(position, replacement);
        }
    }

    private int indexOfLocalParameter(@NotNull @NonNls Condition<? super String> condition) {
        return ContainerUtil.lastIndexOf(this.myParameters, value -> condition.value((Object)value.getLocalValue()));
    }

    public void set(int ind, @NotNull @NonNls String value) {
        this.myParameters.set(ind, new CompositeParameterTargetedValue(value));
    }

    public String get(int ind) {
        return this.myParameters.get(ind).getLocalValue();
    }

    @Nullable
    public String getLast() {
        return this.myParameters.size() > 0 ? this.myParameters.get(this.myParameters.size() - 1).getLocalValue() : null;
    }

    public void add(@NotNull @NonNls String name, @NotNull @NonNls String value) {
        this.myParameters.add(new CompositeParameterTargetedValue(name));
        this.add(value);
    }

    public void addAll(String ... parameters) {
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(@NotNull @NonNls List<String> parameters) {
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        return this.copyTo(new ParametersList());
    }

    @NotNull
    public ParametersList copyTo(@NotNull ParametersList target) {
        target.myParameters.addAll(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            target.myGroups.add(group.clone());
        }
        return target;
    }

    @NotNull
    public static String join(@NotNull @NonNls List<String> parameters) {
        return ParametersListUtil.join(parameters);
    }

    @NotNull
    public static String join(String ... parameters) {
        return ParametersListUtil.join(parameters);
    }

    public static String @NotNull [] parse(@NotNull @NonNls String string2) {
        return ParametersListUtil.parseToArray(string2);
    }

    @NotNull
    public String expandMacros(@NotNull @NonNls String text) {
        int start = text.indexOf("${");
        if (start < 0) {
            return text;
        }
        Map<String, String> macroMap = this.myMacroMap.getValue();
        Matcher matcher = MACRO_PATTERN.matcher(text);
        StringBuilder sb = null;
        while (matcher.find(start)) {
            String value = macroMap.get(matcher.group(1));
            if (value != null) {
                if (sb == null) {
                    sb = new StringBuilder(2 * text.length()).append(text, 0, matcher.start());
                } else {
                    sb.append(text, start, matcher.start());
                }
                sb.append(value);
                start = matcher.end();
                continue;
            }
            if (sb != null) {
                sb.append(text, start, matcher.start() + 2);
            }
            start = matcher.start() + 2;
        }
        return sb == null ? text : sb.append(text, start, text.length()).toString();
    }

    public void patchMacroWithEnvs(Map<String, String> envs) {
        this.myMacroMap.getValue().putAll(envs);
    }

    @TestOnly
    public static void setTestMacros(@Nullable @NonNls Map<String, String> testMacros) {
        ourTestMacros = testMacros;
    }

    @NotNull
    private static Map<String, String> computeMacroMap() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() && ourTestMacros != null) {
            return ObjectUtils.notNull(ourTestMacros, Collections.emptyMap());
        }
        Map<String, String> map = CollectionFactory.createCaseInsensitiveStringMap();
        Map<String, String> pathMacros = PathMacros.getInstance().getUserMacros();
        if (!pathMacros.isEmpty()) {
            for (String string2 : pathMacros.keySet()) {
                String value = pathMacros.get(string2);
                if (value == null) continue;
                map.put(string2, value);
            }
        }
        for (Map.Entry entry : EnvironmentUtil.getEnvironmentMap().entrySet()) {
            map.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    @NonNls
    public String toString() {
        return this.myParameters + (String)(this.myGroups.isEmpty() ? "" : " and " + this.myGroups);
    }

    private static /* synthetic */ boolean lambda$defineProperty$2(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ boolean lambda$getPropertyValue$1(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }
}

