/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import org.jetbrains.annotations.NotNull;

public class MergeConflictType {
    @NotNull
    private final Type myType;
    private final boolean myLeftChange;
    private final boolean myRightChange;
    private final boolean myCanBeResolved;

    public MergeConflictType(@NotNull Type type, boolean leftChange, boolean rightChange) {
        this(type, leftChange, rightChange, true);
    }

    public MergeConflictType(@NotNull Type type, boolean leftChange, boolean rightChange, boolean canBeResolved) {
        this.myType = type;
        this.myLeftChange = leftChange;
        this.myRightChange = rightChange;
        this.myCanBeResolved = canBeResolved;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    public boolean canBeResolved() {
        return this.myCanBeResolved;
    }

    public boolean isChange(@NotNull Side side) {
        return side.isLeft() ? this.myLeftChange : this.myRightChange;
    }

    public boolean isChange(@NotNull ThreeSide side) {
        switch (side) {
            case LEFT: {
                return this.myLeftChange;
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.myRightChange;
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    public static enum Type {
        INSERTED,
        DELETED,
        MODIFIED,
        CONFLICT;

    }
}

