/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparisonUtil {
    public static boolean isEquals(@Nullable CharSequence text1, @Nullable CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == text2) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        switch (policy) {
            case DEFAULT: {
                return StringUtilRt.equal((CharSequence)text1, (CharSequence)text2, (boolean)true);
            }
            case TRIM_WHITESPACES: {
                return Strings.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.equalsIgnoreWhitespaces(text1, text2);
            }
        }
        throw new IllegalArgumentException(policy.toString());
    }

    public static int hashCode(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
        switch (policy) {
            case DEFAULT: {
                return Strings.stringHashCode(text);
            }
            case TRIM_WHITESPACES: {
                int offset1 = TrimUtil.trimStart(text, 0, text.length());
                int offset2 = TrimUtil.trimEnd(text, offset1, text.length());
                return Strings.stringHashCode(text, offset1, offset2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.stringHashCodeIgnoreWhitespaces(text);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean isEqualTexts(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        switch (policy) {
            case DEFAULT: {
                return StringUtilRt.equal((CharSequence)text1, (CharSequence)text2, (boolean)true);
            }
            case TRIM_WHITESPACES: {
                return ComparisonUtil.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.equalsIgnoreWhitespaces(text1, text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = Strings.indexOf(s1, '\n', index1) + 1;
            int end2 = Strings.indexOf(s2, '\n', index2) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!Strings.equalsTrimWhitespaces(line1, line2 = s2.subSequence(index2, end2))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    public static int getUnimportantLineCharCount() {
        return 3;
    }
}

