/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByLineRt;
import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ChunkOptimizer<T> {
    @NotNull
    protected final List<? extends T> myData1;
    @NotNull
    protected final List<? extends T> myData2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    protected final CancellationChecker myIndicator;
    @NotNull
    private final List<Range> myRanges;

    ChunkOptimizer(@NotNull List<? extends T> data1, @NotNull List<? extends T> data2, @NotNull FairDiffIterable iterable, @NotNull CancellationChecker indicator) {
        this.myData1 = data1;
        this.myData2 = data2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
        this.myRanges = new ArrayList<Range>();
    }

    @NotNull
    public FairDiffIterable build() {
        for (Range range : this.myIterable.iterateUnchanged()) {
            this.myRanges.add(range);
            this.processLastRanges();
        }
        return DiffIterableUtil.fair(DiffIterableUtil.createUnchanged(this.myRanges, this.myData1.size(), this.myData2.size()));
    }

    private void processLastRanges() {
        if (this.myRanges.size() < 2) {
            return;
        }
        Range range1 = this.myRanges.get(this.myRanges.size() - 2);
        Range range2 = this.myRanges.get(this.myRanges.size() - 1);
        if (range1.end1 != range2.start1 && range1.end2 != range2.start2) {
            return;
        }
        int count1 = range1.end1 - range1.start1;
        int count2 = range2.end1 - range2.start1;
        int equalForward = TrimUtil.expandForward(this.myData1, this.myData2, range1.end1, range1.end2, range1.end1 + count2, range1.end2 + count2);
        int equalBackward = TrimUtil.expandBackward(this.myData1, this.myData2, range2.start1 - count1, range2.start2 - count1, range2.start1, range2.start2);
        if (equalForward == 0 && equalBackward == 0) {
            return;
        }
        if (equalForward == count2) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + count2, range1.start2, range1.end2 + count2));
            this.processLastRanges();
            return;
        }
        if (equalBackward == count1) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range2.start1 - count1, range2.end1, range2.start2 - count1, range2.end2));
            this.processLastRanges();
            return;
        }
        Side touchSide = Side.fromLeft(range1.end1 == range2.start1);
        int shift = this.getShift(touchSide, equalForward, equalBackward, range1, range2);
        if (shift != 0) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + shift, range1.start2, range1.end2 + shift));
            this.myRanges.add(new Range(range2.start1 + shift, range2.end1, range2.start2 + shift, range2.end2));
        }
    }

    protected abstract int getShift(@NotNull Side var1, int var2, int var3, @NotNull Range var4, @NotNull Range var5);

    public static class LineChunkOptimizer
    extends ChunkOptimizer<ByLineRt.Line> {
        public LineChunkOptimizer(@NotNull List<? extends ByLineRt.Line> lines1, @NotNull List<? extends ByLineRt.Line> lines2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            super(lines1, lines2, changes, indicator);
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            int threshold = ComparisonUtil.getUnimportantLineCharCount();
            Integer shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            return 0;
        }

        @Nullable
        private Integer getUnchangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            List touchLines = touchSide.select(this.myData1, this.myData2);
            int touchStart = touchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(touchLines, touchStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(touchLines, touchStart - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        @Nullable
        private Integer getChangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            Side nonTouchSide = touchSide.other();
            List nonTouchLines = nonTouchSide.select(this.myData1, this.myData2);
            int changeStart = nonTouchSide.select(range1.end1, range1.end2);
            int changeEnd = nonTouchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(nonTouchLines, changeStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(nonTouchLines, changeEnd - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        private static int findNextUnimportantLine(@NotNull List<? extends ByLineRt.Line> lines, int offset, int count, int threshold) {
            for (int i = 0; i < count; ++i) {
                if (lines.get(offset + i).getNonSpaceChars() > threshold) continue;
                return i;
            }
            return -1;
        }

        private static int findPrevUnimportantLine(@NotNull List<? extends ByLineRt.Line> lines, int offset, int count, int threshold) {
            for (int i = 0; i < count; ++i) {
                if (lines.get(offset - i).getNonSpaceChars() > threshold) continue;
                return i;
            }
            return -1;
        }

        @Nullable
        private static Integer getShift(int shiftForward, int shiftBackward) {
            if (shiftForward == -1 && shiftBackward == -1) {
                return null;
            }
            if (shiftForward == 0 || shiftBackward == 0) {
                return 0;
            }
            return shiftForward != -1 ? shiftForward : -shiftBackward;
        }
    }

    public static class WordChunkOptimizer
    extends ChunkOptimizer<ByWordRt.InlineChunk> {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public WordChunkOptimizer(@NotNull List<? extends ByWordRt.InlineChunk> words1, @NotNull List<? extends ByWordRt.InlineChunk> words2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            super(words1, words2, changes, indicator);
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            int touchStart;
            List touchWords = touchSide.select(this.myData1, this.myData2);
            CharSequence touchText = touchSide.select(this.myText1, this.myText2);
            if (WordChunkOptimizer.isSeparatedWithWhitespace(touchText, (ByWordRt.InlineChunk)touchWords.get((touchStart = touchSide.select(range2.start1, range2.start2)) - 1), (ByWordRt.InlineChunk)touchWords.get(touchStart))) {
                return 0;
            }
            int leftShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart, equalForward, true);
            if (leftShift > 0) {
                return leftShift;
            }
            int rightShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart - 1, equalBackward, false);
            if (rightShift > 0) {
                return -rightShift;
            }
            return 0;
        }

        private static int findSequenceEdgeShift(@NotNull CharSequence text, @NotNull List<? extends ByWordRt.InlineChunk> words, int offset, int count, boolean leftToRight) {
            for (int i = 0; i < count; ++i) {
                ByWordRt.InlineChunk word2;
                ByWordRt.InlineChunk word1;
                if (leftToRight) {
                    word1 = words.get(offset + i);
                    word2 = words.get(offset + i + 1);
                } else {
                    word1 = words.get(offset - i - 1);
                    word2 = words.get(offset - i);
                }
                if (!WordChunkOptimizer.isSeparatedWithWhitespace(text, word1, word2)) continue;
                return i + 1;
            }
            return -1;
        }

        private static boolean isSeparatedWithWhitespace(@NotNull CharSequence text, @NotNull ByWordRt.InlineChunk word1, @NotNull ByWordRt.InlineChunk word2) {
            if (word1 instanceof ByWordRt.NewlineChunk || word2 instanceof ByWordRt.NewlineChunk) {
                return true;
            }
            int offset1 = word1.getOffset2();
            int offset2 = word2.getOffset1();
            for (int i = offset1; i < offset2; ++i) {
                if (!Strings.isWhiteSpace(text.charAt(i))) continue;
                return true;
            }
            return false;
        }
    }
}

