/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ByLineRt {
    @NotNull
    public static FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), policy, indicator);
    }

    @NotNull
    public static List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), ByLineRt.getLines(lines3, policy), policy, indicator, false);
    }

    @NotNull
    public static List<MergeRange> merge(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), ByLineRt.getLines(lines3, policy), policy, indicator, true);
    }

    @NotNull
    static FairDiffIterable doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes = ByLineRt.compareSmart(lines1, lines2, indicator);
            changes = ByLineRt.optimizeLineChunks(lines1, lines2, changes, indicator);
            return ByLineRt.expandRanges(lines1, lines2, changes);
        }
        List<Line> iwLines1 = ByLineRt.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLineRt.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = ByLineRt.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLineRt.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        return ByLineRt.correctChangesSecondStep(lines1, lines2, iwChanges);
    }

    @NotNull
    static List<MergeRange> doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator, boolean keepIgnoredChanges) {
        indicator.checkCanceled();
        List<Line> iwLines1 = ByLineRt.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLineRt.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = ByLineRt.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = ByLineRt.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLineRt.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLineRt.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLineRt.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLineRt.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLineRt.correctChangesSecondStep(lines2, lines3, iwChanges2);
        if (keepIgnoredChanges && policy != ComparisonPolicy.DEFAULT) {
            return ComparisonMergeUtil.buildMerge(iterable1, iterable2, (index1, index2, index3) -> ByLineRt.equalsDefaultPolicy(lines1, lines2, lines3, index1, index2, index3), indicator);
        }
        return ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
    }

    private static boolean equalsDefaultPolicy(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, int index1, int index2, int index3) {
        CharSequence content1 = lines1.get(index1).getContent();
        CharSequence content2 = lines2.get(index2).getContent();
        CharSequence content3 = lines3.get(index3).getContent();
        return ComparisonUtil.isEquals(content2, content1, ComparisonPolicy.DEFAULT) && ComparisonUtil.isEquals(content2, content3, ComparisonPolicy.DEFAULT);
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2, final @NotNull FairDiffIterable changes) {
        final DiffIterableUtil.ExpandChangeBuilder builder = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = 0;
            private int last2 = 0;

            public void run() {
                for (Range range : changes.iterateUnchanged()) {
                    int count = range.end1 - range.start1;
                    for (int i = 0; i < count; ++i) {
                        int index1 = range.start1 + i;
                        int index2 = range.start2 + i;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (ComparisonUtil.isEquals(this.sample, line1.getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(changes.getLength1(), changes.getLength2());
            }

            private void flush(int line1, int line2) {
                int i;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, builder.getIndex1());
                int start2 = Math.max(this.last2, builder.getIndex2());
                IntArrayList subLines1 = new IntArrayList();
                IntArrayList subLines2 = new IntArrayList();
                for (i = start1; i < line1; ++i) {
                    if (!ComparisonUtil.isEquals(this.sample, ((Line)lines1.get(i)).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines1.add(i);
                    this.last1 = i + 1;
                }
                for (i = start2; i < line2; ++i) {
                    if (!ComparisonUtil.isEquals(this.sample, ((Line)lines2.get(i)).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines2.add(i);
                    this.last2 = i + 1;
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching((IntList)subLines1, (IntList)subLines2);
                this.sample = null;
            }

            private void alignExactMatching(IntList subLines1, IntList subLines2) {
                boolean skipAligning;
                int n = Math.max(subLines1.size(), subLines2.size());
                boolean bl = skipAligning = n > 10 || subLines1.size() == subLines2.size();
                if (skipAligning) {
                    int count = Math.min(subLines1.size(), subLines2.size());
                    for (int i = 0; i < count; ++i) {
                        int index1 = subLines1.getInt(i);
                        int index2 = subLines2.getInt(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLineRt.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i = 0; i < subLines1.size(); ++i) {
                        int index1 = subLines1.getInt(i);
                        int index2 = subLines2.getInt(matching[i]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLineRt.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i = 0; i < subLines2.size(); ++i) {
                        int index1 = subLines1.getInt(matching[i]);
                        int index2 = subLines2.getInt(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        return DiffIterableUtil.fair(builder.finish());
    }

    private static int @NotNull [] getBestMatchingAlignment(final @NotNull IntList subLines1, final @NotNull IntList subLines2, final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2) {
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i = 0; i < size; ++i) {
            best[i] = i;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start, int n, int k) {
                if (k == size) {
                    this.processCombination();
                    return;
                }
                for (int i = start; i <= n; ++i) {
                    comb[k] = i;
                    this.combinations(i + 1, n, k + 1);
                }
            }

            private void processCombination() {
                int weight = 0;
                for (int i = 0; i < size; ++i) {
                    int index1 = subLines1.getInt(i);
                    int index2 = subLines2.getInt(comb[i]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight;
                }
                if (weight > this.bestWeight) {
                    this.bestWeight = weight;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable, @NotNull CancellationChecker indicator) {
        return new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull CancellationChecker indicator) {
        int threshold = ComparisonUtil.getUnimportantLineCharCount();
        if (threshold == 0) {
            return DiffIterableUtil.diff(lines1, lines2, indicator);
        }
        Pair<List<Line>, IntList> bigLines1 = ByLineRt.getBigLines(lines1, threshold);
        Pair<List<Line>, IntList> bigLines2 = ByLineRt.getBigLines(lines2, threshold);
        FairDiffIterable changes = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        return new ChangeCorrector.SmartLineChangeCorrector((IntList)bigLines1.second, (IntList)bigLines2.second, lines1, lines2, changes, indicator).build();
    }

    @NotNull
    private static Pair<List<Line>, IntList> getBigLines(@NotNull List<? extends Line> lines, int threshold) {
        ArrayList<Line> bigLines = new ArrayList<Line>(lines.size());
        IntArrayList indexes = new IntArrayList(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            Line line = lines.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i);
        }
        return Pair.create(bigLines, (Object)indexes);
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable) {
        ArrayList<Range> changes = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes.add(expanded);
        }
        return DiffIterableUtil.fair(DiffIterableUtil.create(changes, lines1.size(), lines2.size()));
    }

    @NotNull
    private static List<Line> getLines(@NotNull List<? extends CharSequence> text, @NotNull ComparisonPolicy policy) {
        return text.stream().map(line -> new Line((CharSequence)line, policy)).collect(Collectors.toList());
    }

    @NotNull
    private static List<Line> convertMode(@NotNull List<? extends Line> original, @NotNull ComparisonPolicy policy) {
        ArrayList<Line> result = new ArrayList<Line>(original.size());
        for (Line line : original) {
            Line newLine = line.myPolicy != policy ? new Line(line.getContent(), policy) : line;
            result.add(newLine);
        }
        return result;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts) {
        return conflicts.stream().map(ch -> new MergeLineFragmentImpl((MergeRange)ch)).collect(Collectors.toList());
    }

    static class Line {
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final ComparisonPolicy myPolicy;
        private final int myHash;
        private final int myNonSpaceChars;

        Line(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
            this.myText = text;
            this.myPolicy = policy;
            this.myHash = ComparisonUtil.hashCode(text, policy);
            this.myNonSpaceChars = Line.countNonSpaceChars(text);
        }

        @NotNull
        public CharSequence getContent() {
            return this.myText;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myPolicy == line.myPolicy);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return ComparisonUtil.isEquals(this.getContent(), line.getContent(), this.myPolicy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static int countNonSpaceChars(@NotNull CharSequence text) {
            int nonSpace = 0;
            int len = text.length();
            for (int offset = 0; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (Strings.isWhiteSpace(c)) continue;
                ++nonSpace;
            }
            return nonSpace;
        }
    }
}

