/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.tracing;

import com.intellij.diagnostic.tracing.MethodTracer;
import org.jetbrains.annotations.NotNull;

public class MethodTracerData {
    @NotNull
    public final MethodTracer.TracerId id;
    public final String className;
    public final String methodName;
    public final long invocationCount;
    public final long nonRecursiveCount;
    public final long totalTime;
    public final long maxTime;
    public final long countOnEdt;
    public final long timeOnEdt;
    public final long maxTimeOnEdt;
    public final int maxRecursionDepth;

    public MethodTracerData(@NotNull MethodTracer.TracerId id, String className, String methodName, long invocationCount, long nonRecursiveCount, long totalTime, long maxTime, long countOnEdt, long timeOnEdt, long maxTimeOnEdt, int maxRecursionDepth) {
        this.id = id;
        this.className = className;
        this.methodName = methodName;
        this.invocationCount = invocationCount;
        this.nonRecursiveCount = nonRecursiveCount;
        this.totalTime = totalTime;
        this.maxTime = maxTime;
        this.maxRecursionDepth = maxRecursionDepth;
        this.countOnEdt = countOnEdt;
        this.timeOnEdt = timeOnEdt;
        this.maxTimeOnEdt = maxTimeOnEdt;
    }

    public double getAvgTime() {
        return MethodTracerData.average(this.totalTime, this.nonRecursiveCount);
    }

    public double getAvgTimeEdt() {
        return MethodTracerData.average(this.timeOnEdt, this.countOnEdt);
    }

    private static double average(long total, long count) {
        if (count == 0L) {
            return 0.0;
        }
        double avg = (double)total / (double)count;
        return (double)Math.round(avg * 100.0) / 100.0;
    }
}

