/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ImplementationConflictException
extends RuntimeException {
    @NotNull
    private static final PluginId CORE_PLUGIN_ID = PluginId.getId("com.intellij");
    @NotNull
    private final Set<PluginId> myConflictingPluginIds;

    public ImplementationConflictException(@NotNull String message, Throwable cause, Object ... implementationObjects) {
        super(message + ". Conflicting plugins: " + ImplementationConflictException.calculateConflicts(implementationObjects), cause);
        this.myConflictingPluginIds = ImplementationConflictException.calculateConflicts(implementationObjects);
    }

    @NotNull
    private static Set<PluginId> calculateConflicts(Object ... implementationObjects) {
        HashSet<PluginId> myConflictingPluginIds = new HashSet<PluginId>();
        for (Object object : implementationObjects) {
            ClassLoader classLoader = object.getClass().getClassLoader();
            if (classLoader instanceof PluginAwareClassLoader) {
                myConflictingPluginIds.add(((PluginAwareClassLoader)((Object)classLoader)).getPluginId());
                continue;
            }
            myConflictingPluginIds.add(CORE_PLUGIN_ID);
        }
        return myConflictingPluginIds;
    }

    @NotNull
    public Set<PluginId> getConflictingPluginIds() {
        return new HashSet<PluginId>(ContainerUtil.subtract(this.myConflictingPluginIds, Collections.singleton(CORE_PLUGIN_ID)));
    }

    public boolean isConflictWithPlatform() {
        return this.myConflictingPluginIds.contains(CORE_PLUGIN_ID);
    }
}

