/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.AWTEvent;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompositeEventWatcher
implements EventWatcher,
Disposable {
    private final EventWatcher[] watchers;

    public CompositeEventWatcher(EventWatcher ... watchers) {
        this.watchers = (EventWatcher[])watchers.clone();
        for (int i = 0; i < watchers.length; ++i) {
            EventWatcher watcher = watchers[i];
            Objects.requireNonNull(watcher, "watchers must not be null, but watcher[" + i + "] is null");
            if (!(watcher instanceof Disposable)) continue;
            Disposable disposable = (Disposable)((Object)watcher);
            Disposer.register(this, disposable);
        }
    }

    @Override
    public void runnableTaskFinished(@NotNull Runnable runnable, long waitedInQueueNs, int queueSize, long executionDurationNs) {
        for (EventWatcher watcher : this.watchers) {
            watcher.runnableTaskFinished(runnable, waitedInQueueNs, queueSize, executionDurationNs);
        }
    }

    @Override
    public void edtEventStarted(@NotNull AWTEvent event, long startedAtMs) {
        for (EventWatcher watcher : this.watchers) {
            watcher.edtEventStarted(event, startedAtMs);
        }
    }

    @Override
    public void edtEventFinished(@NotNull AWTEvent event, long finishedAtMs) {
        for (EventWatcher watcher : this.watchers) {
            watcher.edtEventFinished(event, finishedAtMs);
        }
    }

    @Override
    public void logTimeMillis(@NotNull String processId, long startedAtMs, @NotNull Class<? extends Runnable> runnableClass) {
        for (EventWatcher watcher : this.watchers) {
            watcher.logTimeMillis(processId, startedAtMs, runnableClass);
        }
    }

    @Override
    public void reset() {
        for (EventWatcher watcher : this.watchers) {
            watcher.reset();
        }
    }

    @Override
    public void dispose() {
    }
}

