/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    @NotNull
    private static String ourLangTag = Locale.ENGLISH.toLanguageTag();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        super(bundleClass, pathToBundle);
    }

    public DynamicBundle(@NotNull String pathToBundle) {
        super(pathToBundle);
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        return DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, loader -> super.findBundle(pathToBundle, (ClassLoader)loader, control));
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull @NotNull Function<? super @NotNull ClassLoader, ? extends @NotNull ResourceBundle> bundleResolver) {
        ResourceBundle base = bundleResolver.apply(baseLoader);
        ClassLoader pluginClassLoader = DynamicBundle.languagePluginClassLoader(bundleClassLoader);
        if (pluginClassLoader == null) {
            return base;
        }
        ResourceBundle pluginBundle = bundleResolver.apply(pluginClassLoader);
        if (!DynamicBundle.setBundleParent(pluginBundle, base)) {
            return base;
        }
        return pluginBundle;
    }

    @Nullable
    private static ClassLoader languagePluginClassLoader(@NotNull ClassLoader bundleClassLoader) {
        if (DefaultBundleService.isDefaultBundle()) {
            return null;
        }
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return null;
        }
        PluginDescriptor pluginDescriptor = langBundle.pluginDescriptor;
        return pluginDescriptor == null ? bundleClassLoader : pluginDescriptor.getClassLoader();
    }

    private static boolean setBundleParent(@NotNull ResourceBundle pluginBundle, ResourceBundle base) {
        if (pluginBundle == base) {
            return true;
        }
        try {
            if (DynamicBundleInternal.SET_PARENT != null) {
                DynamicBundleInternal.SET_PARENT.bindTo(pluginBundle).invoke(base);
            }
            return true;
        }
        catch (Throwable e) {
            LOG.warn(e);
            return false;
        }
    }

    @Nullable
    public static LanguageBundleEP findLanguageBundle() {
        try {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || !app.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader) {
        return DynamicBundle.getResourceBundle(loader, pathToBundle);
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle) {
        return (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle));
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle) {
        return DynamicBundle.resolveResourceBundleWithFallback(() -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader, DynamicBundle.bundleResolver(pathToBundle)), loader, pathToBundle);
    }

    @NotNull
    private static @NotNull Function<@NotNull ClassLoader, @NotNull ResourceBundle> bundleResolver(@NonNls @NotNull String pathToBundle) {
        return l -> AbstractBundle.resolveBundle(l, pathToBundle);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class<?> callerClass = ReflectionUtil.findCallerClass(2);
        return DynamicBundle.getBundle(baseName, callerClass == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        final ResourceBundle rb = DynamicBundle.getResourceBundle(formClass.getClassLoader(), baseName);
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                Object get = rb.getObject(key);
                assert (get instanceof String) : "Language bundles should contain only strings";
                return BundleBase.appendLocalizationSuffix((String)get, "\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                return rb.getKeys();
            }
        };
    }

    public static void loadLocale(@Nullable LanguageBundleEP langBundle) {
        if (langBundle != null) {
            ourLangTag = langBundle.locale;
            ourCache.clear();
        }
    }

    @NotNull
    public static Locale getLocale() {
        return Locale.forLanguageTag(ourLangTag);
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        public PluginDescriptor pluginDescriptor;

        @Override
        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            this.pluginDescriptor = pluginDescriptor;
        }
    }

    private static class DynamicBundleInternal {
        private static final MethodHandle SET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

