/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.resolve.FrameworkRootModuleMapCollector;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFrameworkFilter;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworksSearchRoot
extends FrameworksRoot
implements ModuleMapLocationProvider {
    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project, @NotNull VirtualFile file) {
        return new Transient(project, file);
    }

    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project, @NotNull VirtualFilePointer pointer) {
        return new Pointer(project, pointer);
    }

    private FrameworksSearchRoot(@NotNull Project project) {
        super(project);
    }

    @NotNull
    public abstract String getUrl();

    @Nls
    @NotNull
    public String getPresentableName() {
        return OCBundle.message("header.search.root.frameworks", new Object[0]);
    }

    public boolean processFrameworks(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2, @NotNull Set<? super String> processed, boolean includeSdkFrameworks) {
        return FrameworksSearchRoot.processFrameworksUnder((PsiFileSystemItem)this, this.getVirtualFile(), processor2, processed);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2, @NotNull Set<? super String> processed) {
        Project project = parentSdkOrFramework.getProject();
        if (root != null && root.isValid() && root.isDirectory() && !project.isDisposed()) {
            VirtualFile[] frameworkPaths;
            for (VirtualFile frameworkPath : frameworkPaths = AppleFrameworkFilter.Companion.filter(project, root.getChildren())) {
                RealFramework framework;
                if (!AppleFramework.isFrameworkRoot((VirtualFile)frameworkPath) || (framework = new RealFramework(project, frameworkPath, parentSdkOrFramework)).process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        ArrayList<HeadersSearchRoot> roots2 = new ArrayList<HeadersSearchRoot>();
        this.processChildren((PsiElementProcessor)new FrameworkRootModuleMapCollector(this.myProject, roots2));
        return roots2;
    }

    public String toString() {
        return "FrameworksSearchRoot: " + this.getUrl();
    }

    private static final class Transient
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFile myRoot;

        private Transient(@NotNull Project project, @NotNull VirtualFile root) {
            super(project);
            this.myRoot = root;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRoot;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myRoot.getUrl();
        }

        public boolean isValid() {
            return this.myRoot.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myRoot.equals(((Transient)o).myRoot);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot);
        }
    }

    private static final class Pointer
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFilePointer myRootPointer;

        private Pointer(@NotNull Project project, @NotNull VirtualFilePointer root) {
            super(project);
            this.myRootPointer = root;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRootPointer.getFile();
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myRootPointer.getUrl();
        }

        public boolean isValid() {
            return this.myRootPointer.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pointer pointer = (Pointer)o;
            return this.myRootPointer.equals(pointer.myRootPointer);
        }

        public int hashCode() {
            return Objects.hash(this.myRootPointer);
        }
    }
}

