/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersRoot
implements SurrogateSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    protected final List<VirtualFile> myHeaders;
    private final HeadersSearchPath.Kind myKind;
    private final int myHashCodeCache;

    protected CustomHeadersRoot(@NotNull Project project, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> headers, @NotNull HeadersSearchPath.Kind kind) {
        super(project);
        this.myRoot = root;
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(headers);
        this.myHeaders = ContainerUtil.unmodifiableOrEmptyList(filesList);
        this.myKind = kind;
        int hashCode = Objects.hashCode(this.myRoot);
        hashCode = 31 * hashCode + this.myHeaders.hashCode();
        this.myHashCodeCache = hashCode = 31 * hashCode + this.myKind.ordinal();
    }

    @Nls
    @NotNull
    public String getPresentableName() {
        return OCBundle.message("header.search.root.custom.headers", new Object[0]);
    }

    @NotNull
    public HeadersSearchPath.Kind getKind() {
        return this.myKind;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    @NotNull
    public List<VirtualFile> getHeaders() {
        return this.myHeaders;
    }

    public boolean isValid() {
        return this.myRoot == null || this.myRoot.isValid();
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2) {
        if (processor2 instanceof HeadersSearchRootProcessor && ((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
            return true;
        }
        return this.processCustomFileSet(processor2, this.myHeaders, false);
    }

    public String toString() {
        return this.getName() + ", size: " + this.myHeaders.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)o;
        return this.myKind == root.myKind && this.myHashCodeCache == root.myHashCodeCache && Objects.equals(this.myRoot, root.myRoot) && this.myHeaders.equals(root.myHeaders);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }
}

