/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructuredBindingUtil {
    public static OCType resolveInitializerType(@NotNull OCStructuredBindingType type, @NotNull OCResolveContext context) {
        if (type.isInForeachStatement()) {
            OCExpression foreachCollection = type.getInitializerElement();
            if (foreachCollection != null) {
                OCType foreachCollectionType = foreachCollection.getResolvedType(context);
                return OCCodeInsightUtil.getCollectionElementType(foreachCollection, foreachCollectionType);
            }
        } else {
            OCExpressionSymbol initializer = type.getInitializerSymbol();
            if (initializer != null) {
                return initializer.getResolvedType(context);
            }
        }
        return null;
    }

    public static boolean isTupleLikeType(@NotNull OCStructType structType, @NotNull OCResolveContext context, @NotNull PsiFile file) {
        return OCStructuredBindingUtil.getTupleSizeSymbol(structType, context, file) != null;
    }

    @Nullable
    public static OCStructSymbol getTupleSizeSymbol(OCStructType structType, @NotNull OCResolveContext context, @NotNull PsiFile file) {
        List<OCTypeArgument> templateArgs = Collections.singletonList(structType);
        OCQualifiedNameWithArguments stdTupleSize = new OCQualifiedNameWithArguments(OCQualifiedName.with("std"), "tuple_size", templateArgs);
        OCSymbolReference.GlobalReference stdTupleSizeReference = OCSymbolReference.getGlobalReference(stdTupleSize, null, file.getVirtualFile(), -1L);
        List<OCSymbol> foundStdTupleSizeSymbols = stdTupleSizeReference.resolveToSymbols(true, true, true, context);
        for (OCSymbol stdTupleSizeSymbol : foundStdTupleSizeSymbols) {
            OCStructSymbol stdTupleSizeStructSymbol;
            if (!(stdTupleSizeSymbol instanceof OCStructSymbol) || (stdTupleSizeStructSymbol = (OCStructSymbol)stdTupleSizeSymbol).isEnum() || !stdTupleSizeStructSymbol.isSpecialization() || !stdTupleSizeStructSymbol.isDefinition()) continue;
            return stdTupleSizeStructSymbol;
        }
        return null;
    }

    public static OCDeclaratorSymbol getTupleSizeValueSymbol(@NotNull OCStructSymbol tupleSizeSymbol, @NotNull OCResolveContext context) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCStructType.processMembersOfNamespace(tupleSizeSymbol, "value", false, false, (Processor<? super OCSymbol>)finder, context);
        OCSymbol valueSymbol = (OCSymbol)finder.getFoundValue();
        if (valueSymbol instanceof OCDeclaratorSymbol) {
            return (OCDeclaratorSymbol)valueSymbol;
        }
        return null;
    }

    @Nullable
    public static OCType getTupleElementType(@NotNull OCStructType tupleType, int elementIndex, @NotNull OCResolveContext context, @NotNull PsiFile file) {
        OCLiteralExpressionSymbol elementIndexExpression = new OCLiteralExpressionSymbol(elementIndex, null, null);
        List<OCTypeArgument> templateArgs = Arrays.asList(new OCExpressionTypeArgument(elementIndexExpression), tupleType);
        OCQualifiedNameWithArguments stdTupleElement = new OCQualifiedNameWithArguments(OCQualifiedName.with("std"), "tuple_element", templateArgs);
        OCSymbolReference.GlobalReference stdTupleElementReference = OCSymbolReference.getGlobalReference(stdTupleElement, null, file.getVirtualFile(), -1L);
        List<OCSymbol> foundStdTupleElementSymbols = stdTupleElementReference.resolveToSymbols(true, true, true, context);
        for (OCSymbol stdTupleElementSymbol : foundStdTupleElementSymbols) {
            OCStructSymbol stdTupleElementStructSymbol;
            if (!(stdTupleElementSymbol instanceof OCStructSymbol) || (stdTupleElementStructSymbol = (OCStructSymbol)stdTupleElementSymbol).isEnum() || !stdTupleElementStructSymbol.isSpecialization()) continue;
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            OCStructType.processMembersOfNamespace(stdTupleElementStructSymbol, "type", false, true, (Processor<? super OCSymbol>)finder, context);
            OCSymbol typeSymbol = (OCSymbol)finder.getFoundValue();
            if (typeSymbol == null || !typeSymbol.getKind().isType()) continue;
            return typeSymbol.getResolvedType(context);
        }
        return null;
    }

    @Nullable
    public static OCType getStructMemberType(@NotNull OCStructType classType, int index, @NotNull OCResolveContext context) {
        MemberCollector memberCollector = new MemberCollector();
        classType.processMembers(null, memberCollector, context);
        if (!memberCollector.hasAnonymousUnionMember() && memberCollector.getBaseClassesWithNonStaticMembers().size() == 1) {
            Object[] members = memberCollector.getMembers();
            ContainerUtil.sort((Object[])members, Comparator.comparingLong(OCSymbol::getComplexOffset));
            if (members.length > index) {
                return members[index].getResolvedType(context);
            }
        }
        return null;
    }

    public static class MemberCollector
    implements Processor<OCSymbol> {
        private final CommonProcessors.CollectProcessor<OCSymbol> myCollector;
        private boolean myHasAnonymousUnionMember;
        private final List<OCStructSymbol> myBaseClassesWithNonStaticMembers = new ArrayList<OCStructSymbol>();

        public MemberCollector() {
            this.myCollector = new CommonProcessors.CollectProcessor();
        }

        public boolean process(OCSymbol symbol) {
            OCStructSymbol memberTypeSymbol;
            if (!(symbol instanceof OCDeclaratorSymbol)) {
                return true;
            }
            OCDeclaratorSymbol memberDeclarator = (OCDeclaratorSymbol)symbol;
            if (memberDeclarator.isStatic()) {
                return true;
            }
            OCType memberType = memberDeclarator.getType();
            if (memberType instanceof OCStructType && (memberTypeSymbol = ((OCStructType)memberType).getSymbol()).getKind() == OCSymbolKind.UNION && memberTypeSymbol.isUnnamed()) {
                this.myHasAnonymousUnionMember = true;
                return false;
            }
            OCSymbolWithQualifiedName parent = memberDeclarator.getParent();
            if (!(parent instanceof OCStructSymbol)) {
                return false;
            }
            if (!this.myBaseClassesWithNonStaticMembers.contains(parent)) {
                this.myBaseClassesWithNonStaticMembers.add((OCStructSymbol)parent);
            }
            return this.myCollector.process((Object)memberDeclarator);
        }

        public OCSymbol @NotNull [] getMembers() {
            return (OCSymbol[])this.myCollector.toArray((Object[])new OCSymbol[0]);
        }

        public List<OCStructSymbol> getBaseClassesWithNonStaticMembers() {
            return this.myBaseClassesWithNonStaticMembers;
        }

        public boolean hasAnonymousUnionMember() {
            return this.myHasAnonymousUnionMember;
        }
    }
}

