/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCStringCodec;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCStringLiteralUtil
extends CidrStringLiteralUtil {
    private static final Logger LOG = Logger.getInstance(OCStringLiteralUtil.class);

    @NotNull
    public static OCStringLiteral concatStrings(OCStringLiteral ... stringLiterals) {
        return (OCStringLiteral)OCStringLiteralUtil.concatStrings((CidrStringCodec)OCStringCodec.STRING_CODEC, (CidrStringLiteral[])stringLiterals);
    }

    @NotNull
    public static OCStringLiteral parseStringLiteral(@Nullable String literalText) {
        return (OCStringLiteral)OCStringLiteralUtil.parseStringLiteral((CidrStringCodec)OCStringCodec.STRING_CODEC, (String)literalText);
    }

    @NotNull
    public static OCCharLiteral parseCharLiteral(@Nullable String literalText) {
        String contents;
        if (literalText == null) {
            return OCCharLiteral.BAD_LITERAL;
        }
        int length = literalText.length();
        if (length == 0) {
            return OCCharLiteral.BAD_LITERAL;
        }
        int quoteChar = 39;
        int firstQuotePos = literalText.indexOf(39);
        if (firstQuotePos == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            return OCCharLiteral.BAD_LITERAL;
        }
        String prefixString = literalText.substring(0, firstQuotePos);
        CidrStringLiteralUtil.CidrCharType charType = (CidrStringLiteralUtil.CidrCharType)CHAR_PREFIX_TYPE.get(prefixString);
        if (charType == null) {
            return OCCharLiteral.BAD_LITERAL;
        }
        if (firstQuotePos == length - 1) {
            contents = "";
        } else {
            contents = literalText.substring(firstQuotePos + 1);
            if (literalText.charAt(length - 1) == '\'') {
                contents = contents.substring(0, contents.length() - 1);
            }
        }
        if (prefixString.isEmpty() && contents.length() > 1) {
            charType = CidrStringLiteralUtil.CidrCharType.MULTICHAR_LITERAL;
        }
        return new OCCharLiteral(charType, prefixString, contents);
    }
}

