/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import org.jetbrains.annotations.NotNull;

public class OCStringCodec
implements CidrStringCodec<OCStringLiteral> {
    public static final OCStringCodec STRING_CODEC = new OCStringCodec();

    @NotNull
    public OCStringLiteral createStringLiteral(@NotNull CidrStringLiteralUtil.CidrStringPrefix prefix, @NotNull String string) {
        return new OCStringLiteral(prefix, string);
    }

    @NotNull
    public OCRawStringLexerBase createRawStringLexer() {
        return OCHighlightingLexer.createRawStringLexer((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
    }

    @NotNull
    public OCStringLiteral getBadLiteral() {
        return OCStringLiteral.BAD_LITERAL;
    }

    @NotNull
    public TokenSet getAllLiterals() {
        return OCLexerTokenTypes.ALL_STRINGS;
    }

    @NotNull
    public static OCIntType getType(@NotNull CidrIntType cidrIntType) {
        return switch (cidrIntType) {
            default -> throw new IncompatibleClassChangeError();
            case CidrIntType.INT -> OCIntType.INT;
            case CidrIntType.CHAR -> OCIntType.CHAR;
            case CidrIntType.CHAR_CONST -> OCIntType.CHAR_CONST;
            case CidrIntType.WCHAR -> OCIntType.WCHAR;
            case CidrIntType.WCHAR_CONST -> OCIntType.WCHAR_CONST;
            case CidrIntType.CHAR16 -> OCIntType.CHAR16;
            case CidrIntType.CHAR16_CONST -> OCIntType.CHAR16_CONST;
            case CidrIntType.CHAR32 -> OCIntType.CHAR32;
            case CidrIntType.CHAR32_CONST -> OCIntType.CHAR32_CONST;
        };
    }
}

