/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatSpecifiersUtil {
    @NonNls
    public static final String POINTER_TYPE_REQUIRED = "<pointer type required>";
    private static final Pattern FORMAT_ATTRIBUTE_PATTERN = Pattern.compile("_{0,2}format_{0,2}#_{0,2}([^_\\s]*)_{0,2}\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    @NonNls
    private static final Map<String, FormatSpecifiersInfo> PREDEFINED_FORMAT_FUNCTIONS = Map.ofEntries(Map.entry("printf", new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), Map.entry("wprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), Map.entry("fprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Map.entry("fwprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Map.entry("sprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Map.entry("swprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Map.entry("snprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 2, 3)), Map.entry("asprintf", new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Map.entry("scanf", new FormatSpecifiersInfo(FormatType.SCANF, 0, 1)), Map.entry("fscanf", new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Map.entry("sscanf", new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Map.entry("strftime", new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Map.entry("wcsftime", new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Map.entry("put_time", new FormatSpecifiersInfo(FormatType.STRFTIME, 1, 0)));

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NotNull OCType type, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(type), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NonNls @NotNull String typeName, boolean typeIsPointer, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(typeName, typeIsPointer), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @Nullable
    public static Pair<FormatSpecifiersInfo, List<SpecifierUsage>> getFormatSpecifiersInfo(@NotNull OCSymbol callable, @NotNull List<OCExpression> arguments) {
        OCExpression formatStringArg;
        List<SpecifierUsage> specifiers;
        OCFile file;
        FormatSpecifiersInfo info = null;
        for (String attribute2 : callable.getAttributes()) {
            Matcher matcher = FORMAT_ATTRIBUTE_PATTERN.matcher(attribute2);
            if (!matcher.matches()) continue;
            FormatType formatType = FormatType.getFormatTypeFromName(matcher.group(1));
            if (formatType == null) {
                return null;
            }
            info = new FormatSpecifiersInfo(formatType, Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)) - 1);
        }
        if (info == null) {
            info = PREDEFINED_FORMAT_FUNCTIONS.get(callable.getName());
        }
        if (info == null) {
            return null;
        }
        if (info.formatStringIndex < 0 || info.formatStringIndex >= info.argumentsIndex || info.formatStringIndex >= arguments.size()) {
            return null;
        }
        if (info.formatType == FormatType.PRINTF && OCCompilerFeaturesHelper.supportsMsvcExtensions(file = arguments.get(0).getContainingOCFile())) {
            info.formatType = FormatType.PRINTF_MSVC;
        }
        if ((specifiers = info.formatType.collectFormatSpecifiers(formatStringArg = arguments.get(info.formatStringIndex))) == null) {
            return null;
        }
        return Pair.create((Object)info, specifiers);
    }

    @Nullable
    public static OCType getFormatArgumentType(@NotNull OCSymbol callable, int argumentIndex, @NotNull List<OCExpression> arguments) {
        Pair<FormatSpecifiersInfo, List<SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null || ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex < 0 || argumentIndex < ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex || argumentIndex >= arguments.size() || argumentIndex >= ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex + ((List)formatInfo.second).size()) {
            return null;
        }
        int checkFormatSpecIndex = argumentIndex - ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex;
        int currentFormatSpecIndex = 0;
        for (SpecifierUsage specifier : (List)formatInfo.second) {
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (currentFormatSpecIndex == checkFormatSpecIndex) {
                return ((FormatSpecifiersInfo)formatInfo.first).formatType.resolveType(specifier.getName(), OCResolveContext.forPsi(arguments.get(argumentIndex)));
            }
            ++currentFormatSpecIndex;
        }
        return null;
    }

    private static class OCTypeWrapper {
        final String myTypeName;
        final boolean myTypeNameIsPointer;
        final OCType myType;

        OCTypeWrapper(@NotNull OCType type) {
            this.myType = type;
            this.myTypeName = null;
            this.myTypeNameIsPointer = false;
        }

        OCTypeWrapper(@NotNull String typeName, boolean typeNameIsPointer) {
            this.myType = null;
            this.myTypeName = typeName;
            this.myTypeNameIsPointer = typeNameIsPointer;
        }

        public OCType getTypeFromContext(@NotNull OCResolveContext context) {
            if (this.myType != null) {
                return this.myType;
            }
            OCType type = OCReferenceType.resolvedFromText(this.myTypeName, context);
            return this.myTypeNameIsPointer ? OCPointerType.to(type) : type;
        }
    }

    public static enum FormatType {
        PRINTF(Arrays.asList(OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.CHAR), "%s", "%hhn"), OCFormatSpecifiersUtil.p2s(OCIntType.CHAR, "%hhd", "%hhi"), OCFormatSpecifiersUtil.p2s(OCIntType.UCHAR, "%c", "%hhu", "%hho", "%hhx", "%hhX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.WCHAR), "%ls"), OCFormatSpecifiersUtil.p2s(OCIntType.WCHAR, "%lc"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SHORT), "%hn"), OCFormatSpecifiersUtil.p2s(OCIntType.SHORT, "%hd", "%hi"), OCFormatSpecifiersUtil.p2s(OCIntType.USHORT, "%hu", "%ho", "%hx", "%hX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.INT), "%n"), OCFormatSpecifiersUtil.p2s(OCIntType.INT, "*", "%d", "%i"), OCFormatSpecifiersUtil.p2s(OCIntType.UINT, "%u", "%o", "%x", "%X"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONG), "%ln"), OCFormatSpecifiersUtil.p2s(OCIntType.LONG, "%ld", "%li"), OCFormatSpecifiersUtil.p2s(OCIntType.ULONG, "%lu", "%lo", "%lx", "%lX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONGLONG), "%lln"), OCFormatSpecifiersUtil.p2s(OCIntType.LONGLONG, "%lld", "%lli"), OCFormatSpecifiersUtil.p2s(OCIntType.ULONGLONG, "%llu", "%llo", "%llx", "%llX"), OCFormatSpecifiersUtil.p2s(OCRealType.DOUBLE, "%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"), OCFormatSpecifiersUtil.p2s(OCRealType.LONG_DOUBLE, "%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCVoidType.instance()), "%p"), OCFormatSpecifiersUtil.p2s("intmax_t", true, "%jn"), OCFormatSpecifiersUtil.p2s("intmax_t", false, "%jd", "%ji"), OCFormatSpecifiersUtil.p2s("uintmax_t", false, "%ju", "%jo", "%jx", "%jX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SIZE_T), "%zn"), OCFormatSpecifiersUtil.p2s(OCIntType.SSIZE_T, "%zd", "%zi"), OCFormatSpecifiersUtil.p2s(OCIntType.SIZE_T, "%zu", "%zo", "%zx", "%zX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.PTRDIFF_T), "%tn"), OCFormatSpecifiersUtil.p2s(OCIntType.PTRDIFF_T, "%td", "%ti", "%tu", "%to", "%tx", "%tX"), OCFormatSpecifiersUtil.p2s("<errno message, no arg>", false, "%m")), true, "printf"),
        PRINTF_MSVC(ContainerUtil.concat((List)((List)FormatType.PRINTF.myType2spec), Arrays.asList(OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.CHAR), "%hs", "%hS"), OCFormatSpecifiersUtil.p2s(OCIntType.CHAR, "%hc", "%hC"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.WCHAR), "%S", "%lS", "%ws", "%wS"), OCFormatSpecifiersUtil.p2s(OCIntType.WCHAR, "%C", "%lC", "%wc", "%wC"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.__INT32), "%I32n"), OCFormatSpecifiersUtil.p2s(OCIntType.__INT32, "%I32d", "%I32i"), OCFormatSpecifiersUtil.p2s(OCIntType.__UINT32, "%I32u", "%I32o", "%I32x", "%I32X"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.__INT64), "%I64n"), OCFormatSpecifiersUtil.p2s(OCIntType.__INT64, "%I64d", "%I64i"), OCFormatSpecifiersUtil.p2s(OCIntType.__UINT64, "%I64u", "%I64o", "%I64x", "%I64X"), OCFormatSpecifiersUtil.p2s("intmax_t", true, "%In"), OCFormatSpecifiersUtil.p2s("intmax_t", false, "%Id", "%Ii"), OCFormatSpecifiersUtil.p2s("uintmax_t", false, "%Iu", "%Io", "%Ix", "%IX"))), true, "printf"),
        NSSTRING(Arrays.asList(OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.CHAR), "%s", "%hhn"), OCFormatSpecifiersUtil.p2s(OCIntType.CHAR, "%hhd", "%hhD", "%hhi"), OCFormatSpecifiersUtil.p2s(OCIntType.UCHAR, "%c", "%hhu", "%hhU", "%hho", "%hhO", "%hhx", "%hhX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.WCHAR), "%ls", "%S"), OCFormatSpecifiersUtil.p2s(OCIntType.WCHAR, "%lc", "%C"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SHORT), "%hn"), OCFormatSpecifiersUtil.p2s(OCIntType.SHORT, "%hd", "%hD", "%hi"), OCFormatSpecifiersUtil.p2s(OCIntType.USHORT, "%hu", "%hU", "%ho", "%hO", "%hx", "%hX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.INT), "%n"), OCFormatSpecifiersUtil.p2s(OCIntType.INT, "*", "%d", "%D", "%i"), OCFormatSpecifiersUtil.p2s(OCIntType.UINT, "%u", "%U", "%o", "%O", "%x", "%X"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONG), "%ln"), OCFormatSpecifiersUtil.p2s(OCIntType.LONG, "%ld", "%lD", "%li"), OCFormatSpecifiersUtil.p2s(OCIntType.ULONG, "%lu", "%lU", "%lo", "%lO", "%lx", "%lX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONGLONG), "%lln", "%qn"), OCFormatSpecifiersUtil.p2s(OCIntType.LONGLONG, "%lld", "%llD", "%lli", "%qd", "%qD", "%qi"), OCFormatSpecifiersUtil.p2s(OCIntType.ULONGLONG, "%llu", "%llU", "%llo", "%llO", "%llx", "%llX", "%qu", "%qU", "%qo", "%qO", "%qx", "%qX"), OCFormatSpecifiersUtil.p2s(OCRealType.DOUBLE, "%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"), OCFormatSpecifiersUtil.p2s(OCRealType.LONG_DOUBLE, "%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCVoidType.instance()), "%p"), OCFormatSpecifiersUtil.p2s("intmax_t", true, "%jn"), OCFormatSpecifiersUtil.p2s("intmax_t", false, "%jd", "%jD", "%ji"), OCFormatSpecifiersUtil.p2s("uintmax_t", false, "%ju", "%jU", "%jo", "%jO", "%jx", "%jX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SIZE_T), "%zn"), OCFormatSpecifiersUtil.p2s(OCIntType.SSIZE_T, "%zd", "%zD", "%zi"), OCFormatSpecifiersUtil.p2s(OCIntType.SIZE_T, "%zu", "%zU", "%zo", "%zO", "%zx", "%zX"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.PTRDIFF_T), "%tn"), OCFormatSpecifiersUtil.p2s(OCIntType.PTRDIFF_T, "%td", "%tD", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX"), OCFormatSpecifiersUtil.p2s("<errno message, no arg>", false, "%m"), OCFormatSpecifiersUtil.p2s("NSObject", true, "%@")), true, "NSString"),
        SCANF(Arrays.asList(OCFormatSpecifiersUtil.p2s("<skip input>", false, "*"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.CHAR), "%c", "%hhd", "%hhi", "%hhu", "%hho", "%hhx", "%hhX", "%hhn", "%s", "%["), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.WCHAR), "%lc", "%ls", "%l["), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SHORT), "%hd", "%hi", "%hu", "%ho", "%hx", "%hX", "%hn"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.INT), "%d", "%i", "%u", "%o", "%x", "%X", "%n"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONG), "%ld", "%li", "%lu", "%lo", "%lx", "%lX", "%ln"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.LONGLONG), "%lld", "%lli", "%llu", "%llo", "%llx", "%llX", "%lln"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.SIZE_T), "%zd", "%zi", "%zu", "%zU", "%zo", "%zO", "%zx", "%zX", "%zn"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCIntType.PTRDIFF_T), "%td", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX", "%tn"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCRealType.FLOAT), "%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCRealType.DOUBLE), "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCRealType.LONG_DOUBLE), "%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"), OCFormatSpecifiersUtil.p2s(OCPointerType.to(OCPointerType.to(OCVoidType.instance())), "%p"), OCFormatSpecifiersUtil.p2s("intmax_t", true, "%jd", "%ji", "%ju", "%jU", "%jo", "%jO", "%jx", "%jX", "%jn")), true, "scanf"),
        STRFTIME(Collections.singletonList(OCFormatSpecifiersUtil.p2s("tm", true, "%n", "%t", "%Y", "%y", "%C", "%G", "%g", "%b", "%h", "%B", "%m", "%U", "%W", "%V", "%j", "%d", "%e", "%a", "%A", "%w", "%u", "%H", "%I", "%M", "%S", "%c", "%x", "%X", "%D", "%F", "%r", "%R", "%T", "%p", "%Z", "%z")), false, "strftime");

        @Nullable
        private final Collection<Pair<OCTypeWrapper, Set<String>>> myType2spec;
        private final String @NotNull [] mySuffixes;
        private final boolean myNeedArgumentCheck;

        private FormatType(@NonNls @NotNull Collection<Pair<OCTypeWrapper, Set<String>>> type2spec, boolean check, String ... suffixes) {
            this.myType2spec = type2spec;
            this.myNeedArgumentCheck = check;
            this.mySuffixes = suffixes;
        }

        @Nullable
        @Contract(value="null->null")
        static FormatType getFormatTypeFromName(@Nullable String functionOrAttributeName) {
            if (functionOrAttributeName == null) {
                return null;
            }
            for (FormatType type : FormatType.values()) {
                for (String suffix : type.mySuffixes) {
                    if (!functionOrAttributeName.endsWith(suffix)) continue;
                    return type;
                }
            }
            return null;
        }

        @Nullable
        public OCType resolveType(@NotNull String spec, @NotNull OCResolveContext context) {
            if (this.myType2spec == null) {
                return null;
            }
            for (Pair<OCTypeWrapper, Set<String>> rec : this.myType2spec) {
                if (!((Set)rec.second).contains(spec)) continue;
                return ((OCTypeWrapper)rec.first).getTypeFromContext(context);
            }
            return null;
        }

        @Nullable
        @NonNls
        public String getSpecifierForType(@NotNull OCType type, @NotNull PsiElement context) {
            if (!(this != SCANF || type.isCString() || type instanceof OCPointerType && ((OCPointerType)type).getRefType().isCString())) {
                return type instanceof OCPointerType ? PRINTF.getSpecifierForType(((OCPointerType)type).getRefType(), context) : OCFormatSpecifiersUtil.POINTER_TYPE_REQUIRED;
            }
            if (FormatType.equalsByAlias(OCIntType.SSIZE_T, type, context)) {
                return OCIntType.SSIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.SIZE_T, type, context)) {
                return OCIntType.SIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.PTRDIFF_T, type, context)) {
                return OCIntType.PTRDIFF_T.getFormatString();
            }
            return type.getFormatString();
        }

        private static boolean equalsByAlias(@NotNull OCIntType compilerType, @NotNull OCType type, @NotNull PsiElement context) {
            String aliasName = type.getAliasName();
            Project project = context.getProject();
            return aliasName != null && type instanceof OCIntType && (aliasName.equals(compilerType.getAliasName()) || aliasName.equals(compilerType.getText())) && ((OCIntType)type).isSigned() == compilerType.isSigned() && ((OCIntType)type).getBits(context, null, project) == compilerType.getBits(context, null, project);
        }

        @Contract(pure=true)
        public boolean needArgumentsCheck() {
            return this.myNeedArgumentCheck;
        }

        private boolean isSpecifierModifier(char cur, char prev) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NSSTRING, SCANF, PRINTF, PRINTF_MSVC -> {
                    if ((prev == '%' || FormatType.isFlag(prev)) && FormatType.isFlag(cur) && cur != prev || "0123456789.*".indexOf(cur) >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case STRFTIME -> "OE".indexOf(cur) >= 0;
            };
        }

        @Contract(pure=true)
        private static boolean isFlag(char cur) {
            return " +-#0".indexOf(cur) >= 0;
        }

        private boolean isSpecifierPart(char cur) {
            if (Character.isLetter(cur)) {
                return true;
            }
            return switch (this) {
                case NSSTRING -> {
                    if (cur == '@') {
                        yield true;
                    }
                    yield false;
                }
                case SCANF -> {
                    if (cur == '[') {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        @Nullable
        public List<SpecifierUsage> collectFormatSpecifiers(@Nullable OCExpression expression) {
            if (!((expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression)) instanceof OCLiteralExpression)) {
                return null;
            }
            OCResolveContext context = OCResolveContext.forPsi(expression);
            ArrayList<SpecifierUsage> result = new ArrayList<SpecifierUsage>();
            StrFragmentIterator iter = new StrFragmentIterator(expression);
            boolean skipNext = false;
            char cur = '\u0000';
            while (true) {
                if (skipNext) {
                    skipNext = false;
                } else {
                    cur = iter.getNextChar();
                }
                if (cur == '\u0000') break;
                if (cur != '%') continue;
                StringBuilder specifier = new StringBuilder();
                boolean wasNonPercent = false;
                boolean wasNonFormat = false;
                boolean wasCrossLiteralJump = false;
                int numOfPercents = 0;
                int lengthWithFormat = 0;
                int offset = iter.getPos();
                int prevPos = offset - 1;
                while (cur == '%' || this.isSpecifierPart(cur) || this.isSpecifierModifier(cur, iter.getPrevChar())) {
                    if (cur == '%') {
                        if (wasNonPercent || ++numOfPercents == 2) {
                            break;
                        }
                    } else {
                        wasNonPercent = true;
                    }
                    if (wasNonFormat || !this.isSpecifierModifier(cur, iter.getPrevChar())) {
                        wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        specifier.append(cur);
                        if (cur != '%') {
                            wasNonFormat = true;
                        }
                    } else if (cur == '*') {
                        result.add(new SpecifierUsage("*", iter.getPos(), 1, OCHighlightingKeys.OC_FORMAT_STRING_TOKEN));
                    }
                    ++lengthWithFormat;
                    prevPos = iter.getPos();
                    cur = iter.getNextChar();
                    if (cur != '\u0000') continue;
                }
                if (numOfPercents >= 2) {
                    result.add(new SpecifierUsage(specifier.toString(), wasCrossLiteralJump ? -1 : offset, numOfPercents, OCHighlightingKeys.OC_VALID_STRING_ESCAPE));
                    cur = iter.getNextChar();
                    if (cur == '\u0000') {
                        break;
                    }
                } else if (specifier.length() > 0) {
                    String specifierName;
                    int length = specifier.length();
                    int lengthWithFormatFull = lengthWithFormat;
                    boolean isValidSpec = false;
                    while (length > 1) {
                        boolean bl = isValidSpec = this.resolveType(specifier.substring(0, length), context) != null;
                        if (isValidSpec) break;
                        --length;
                        --lengthWithFormat;
                    }
                    if ((specifierName = specifier.substring(0, length)).endsWith("[")) {
                        while (cur != '\u0000') {
                            boolean bl = isValidSpec = cur == ']';
                            if (isValidSpec) break;
                            ++lengthWithFormatFull;
                            prevPos = iter.getPos();
                            cur = iter.getNextChar();
                            wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        }
                        if (cur != '\u0000') {
                            lengthWithFormat = ++lengthWithFormatFull;
                        }
                    }
                    result.add(new SpecifierUsage(specifierName, wasCrossLiteralJump ? -1 : offset, lengthWithFormat, isValidSpec ? OCHighlightingKeys.OC_FORMAT_STRING_TOKEN : OCHighlightingKeys.OC_INVALID_STRING_ESCAPE));
                }
                skipNext = true;
            }
            return iter.wasEmpty() ? null : result;
        }

        public boolean isCompatible(@NotNull OCType requiredType, @NotNull OCType actualType, @NonNls @NotNull String requiredSpecifierName, @NonNls @NotNull String actualSpecifierName, @NotNull PsiElement context) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(context);
            if (requiredSpecifierName.equals(actualSpecifierName) || requiredType.equals(actualType, resolveContext)) {
                return true;
            }
            if (this == PRINTF || this == PRINTF_MSVC || this == NSSTRING) {
                OCType actualSpecType;
                if (requiredSpecifierName.equals("%@") && actualType.isPointer() && OCTollFreeBridges.getNSCounterpart(actualType.getName()) != null) {
                    return true;
                }
                if (requiredSpecifierName.endsWith("n") && actualType.isPointer()) {
                    actualSpecType = ((OCPointerType)actualType).getRefType();
                    if (actualSpecType.isConst()) {
                        return false;
                    }
                    requiredType = ((OCPointerType)requiredType).getRefType();
                } else {
                    actualSpecType = actualType instanceof OCIntType ? actualType : this.resolveType(actualSpecifierName, resolveContext);
                }
                if (actualSpecType != null) {
                    if (requiredType instanceof OCIntType && actualSpecType instanceof OCIntType) {
                        int requiredRank = FormatType.getRank(((OCIntType)requiredType).getCTypeId());
                        int actualRank = FormatType.getRank(((OCIntType)actualSpecType).getCTypeId());
                        if (requiredRank > 0 && actualRank > 0) {
                            return requiredRank == actualRank;
                        }
                        Project project = context.getProject();
                        return ((OCIntType)requiredType).getBits(context, null, project) == ((OCIntType)actualSpecType).getBits(context, null, project);
                    }
                    if (requiredType instanceof OCRealType && actualSpecType instanceof OCRealType) {
                        CTypeId typeId1 = ((OCRealType)requiredType).getCTypeId();
                        CTypeId typeId2 = ((OCRealType)actualSpecType).getCTypeId();
                        return CTypeId.LONG_DOUBLE.equals((Object)typeId1) == CTypeId.LONG_DOUBLE.equals((Object)typeId2);
                    }
                    return requiredType.equals(actualSpecType, resolveContext);
                }
            } else if (this == SCANF && requiredType instanceof OCPointerType && actualType instanceof OCPointerType) {
                OCType actualTypeBase = ((OCPointerType)actualType).getRefType();
                if (actualTypeBase.isConst()) {
                    return false;
                }
                OCType requiredTypeBase = ((OCPointerType)requiredType).getRefType();
                if (requiredTypeBase instanceof OCNumericType && actualTypeBase instanceof OCNumericType) {
                    return ((OCNumericType)requiredTypeBase).getCTypeId() == ((OCNumericType)actualTypeBase).getCTypeId();
                }
            }
            return false;
        }

        private static int getRank(CTypeId typeId) {
            return switch (typeId) {
                case CTypeId.BOOL, CTypeId.SIGNED_CHAR, CTypeId.CHAR, CTypeId.CHAR8_T, CTypeId.CHAR16_T, CTypeId.CHAR32_T, CTypeId.WCHAR_T, CTypeId.SHORT, CTypeId.INT -> 1;
                case CTypeId.LONG -> 2;
                case CTypeId.LONG_LONG -> 3;
                default -> 0;
            };
        }
    }

    public static class FormatSpecifiersInfo {
        public FormatType formatType;
        public int formatStringIndex;
        public int argumentsIndex;

        public FormatSpecifiersInfo(@NotNull FormatType formatType, int formatStringIndex, int argumentsIndex) {
            this.formatType = formatType;
            this.formatStringIndex = formatStringIndex < 0 ? -1 : formatStringIndex;
            this.argumentsIndex = argumentsIndex < 0 ? -1 : argumentsIndex;
        }
    }

    public static class SpecifierUsage {
        @NonNls
        @NotNull
        private final String name;
        private final int lengthWithFormat;
        private final int offset;
        @NotNull
        private final TextAttributesKey specType;

        public SpecifierUsage(@NonNls @NotNull String name, int offset, int lengthWithFormat, @NotNull TextAttributesKey specType) {
            this.name = name;
            this.lengthWithFormat = lengthWithFormat;
            this.offset = offset;
            this.specType = specType;
        }

        @NotNull
        @NonNls
        public String getName() {
            return this.name;
        }

        @NotNull
        public TextAttributesKey getType() {
            return this.specType;
        }

        @Nullable
        public TextRange getRange() {
            return this.offset < 0 ? null : new TextRange(this.offset, this.offset + this.lengthWithFormat);
        }
    }

    private static class StrFragmentIterator {
        public static final char END_MARKER = '\u0000';
        private ASTNode child;
        private int pos = -1;
        private int endPos = -1;
        private boolean BOF = true;
        private boolean hasStringLiteral = false;
        private char cur = '\u0000';
        private char prev = '\u0000';
        private char prevPrev = '\u0000';
        CidrLexerSettings lexerSettings = OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.OBJ_CPP).forHighlighting().build();
        private final OCHighlightingLexer lexer = new OCHighlightingLexer(this.lexerSettings);

        StrFragmentIterator(@NotNull OCExpression expression) {
            this.child = expression.getNode().getFirstChildNode();
        }

        public boolean wasEmpty() {
            return !this.hasStringLiteral;
        }

        private boolean childAdvance() {
            if (this.child != null) {
                if (this.BOF) {
                    this.BOF = false;
                } else {
                    this.child = this.child.getTreeNext();
                }
                while (this.child != null && !OCTokenTypes.ALL_STRINGS.contains(OCElementUtil.getElementType(this.child))) {
                    this.child = this.child.getTreeNext();
                }
                this.hasStringLiteral |= this.child != null;
            }
            return this.child != null;
        }

        private void insideAdvance() {
            this.lexer.start((CharSequence)this.child.getText());
            if (OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(this.child))) {
                this.lexer.advance();
                this.lexer.advance();
                this.lexer.advance();
                this.pos = this.lexer.getTokenStart();
                this.endPos = this.lexer.getTokenEnd();
            } else {
                if (OCTokenTypeProvider.INSTANCE.getRAW_STRING_PREFIX_TYPE() == this.lexer.getTokenType()) {
                    this.lexer.advance();
                }
                this.pos = this.lexer.getTokenStart() + 1;
                this.endPos = this.lexer.getBufferEnd() - 1;
            }
        }

        public int getPos() {
            return this.child == null || this.child instanceof OCMacroForeignLeafElement ? -1 : this.child.getStartOffset() + this.pos;
        }

        public char getPrevChar() {
            return this.prev;
        }

        public char getPrevPrevChar() {
            return this.prevPrev;
        }

        public char getNextChar() {
            this.prevPrev = this.prev;
            this.prev = this.cur;
            if (this.pos == -1 || this.pos + 1 >= this.endPos) {
                while (this.childAdvance()) {
                    this.insideAdvance();
                    if (this.pos >= this.endPos) continue;
                    this.cur = this.lexer.getBufferSequence().charAt(this.pos);
                    return this.cur;
                }
                return '\u0000';
            }
            this.cur = this.lexer.getBufferSequence().charAt(++this.pos);
            return this.cur;
        }
    }
}

