/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCNSDictionaryLiteral;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCFormatSpecifiersUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCExpectedTypeUtil {
    private OCExpectedTypeUtil() {
    }

    public static Collection<OCType> getExpectedTypes(OCExpression expr, boolean convertLiteralTypes, @NotNull OCResolveContext context) {
        PsiElement parent = expr.getParent();
        while (parent instanceof OCParenthesizedExpression) {
            expr = (OCExpression)parent;
            parent = parent.getParent();
        }
        MyParentVisitor visitor = new MyParentVisitor(expr, convertLiteralTypes, context);
        parent.accept((PsiElementVisitor)visitor);
        return visitor.myTypesList;
    }

    public static OCType getExpectedType(OCExpression expr, @NotNull OCResolveContext context) {
        return OCExpectedTypeUtil.getExpectedType(expr, false, context);
    }

    public static OCType getExpectedType(OCExpression expr, boolean convertLiteralTypes, @NotNull OCResolveContext context) {
        Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes(expr, convertLiteralTypes, context);
        return OCExpectedTypeUtil.getExpectedTypeRanked(types);
    }

    @Deprecated
    public static OCType getExpectedType(OCExpression expr, boolean convertLiteralTypes) {
        Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes(expr, convertLiteralTypes);
        return OCExpectedTypeUtil.getExpectedTypeRanked(types);
    }

    @Deprecated
    public static Collection<OCType> getExpectedTypes(@NotNull OCExpression expr, boolean convertLiteralTypes) {
        return OCExpectedTypeUtil.getExpectedTypes(expr, convertLiteralTypes, OCResolveContext.forPsi(expr));
    }

    public static OCType getExpressionType(@NotNull OCExpression expression, boolean convertLiteralTypes) {
        return OCExpectedTypeUtil.getExpressionType(expression, expression.getResolvedType().getGuessedType(), convertLiteralTypes);
    }

    public static OCType getExpressionType(@Nullable OCExpression expression, OCType exprType, boolean convertLiteralTypes) {
        boolean canBeStoredInInt;
        if (!convertLiteralTypes || expression == null) {
            return exprType;
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)expression.getContainingFile(), OCCodeStyleSettings.class);
        OCResolveContext context = OCResolveContext.forPsi(expression);
        boolean bl = canBeStoredInInt = OCIntType.INT.equals(exprType, context) || exprType instanceof OCIntType && ((OCIntType)exprType).getRank(context) < OCIntType.INT.getRank(context) && !OCIntType.isBool(exprType, context);
        if (expression instanceof OCLiteralExpression) {
            IElementType literalType = OCElementUtil.getElementType(expression.getNode().getFirstChildNode());
            if (literalType == OCTokenTypes.INTEGER_LITERAL && canBeStoredInInt) {
                return settings.INTRODUCE_USE_NS_TYPES ? OCReferenceType.resolvedFromText("NSInteger", expression) : OCIntType.INT;
            }
            if (literalType == OCTokenTypes.FLOAT_LITERAL && settings.INTRODUCE_USE_NS_TYPES) {
                return OCReferenceType.resolvedFromText("CGFloat", expression);
            }
            if (literalType == OCTokenTypes.STRING_LITERAL && exprType instanceof OCArrayType) {
                return OCPointerType.to(exprType.getArrayElementType().cloneWithConstModifier(context.getProject()));
            }
        } else if (canBeStoredInInt && OCExpressionEvaluator.evaluate(expression) != null) {
            return settings.INTRODUCE_USE_NS_TYPES ? OCReferenceType.resolvedFromText("NSInteger", expression) : OCIntType.INT;
        }
        return exprType;
    }

    public static OCType getReturnTypeOfBlock(@Nullable OCBlockStatement block) {
        if (block == null) {
            return OCVoidType.instance();
        }
        final Ref answer = new Ref();
        block.accept(new OCRecursiveVisitor(){

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
            }

            @Override
            public void visitReturnStatement(OCReturnStatement stmt) {
                OCExpression expression = stmt.getExpression();
                if (expression == null) {
                    return;
                }
                OCType rType = expression.getResolvedType();
                if (rType.getTerminalType().isUnknown()) {
                    answer.set((Object)OCUnknownType.INSTANCE);
                    return;
                }
                if (answer.isNull()) {
                    answer.set((Object)rType);
                } else {
                    answer.set((Object)((OCType)answer.get()).getLeastCommonType(rType, OCResolveContext.forPsi(stmt)));
                }
            }
        });
        return answer.isNull() ? OCVoidType.instance() : (OCType)answer.get();
    }

    @NotNull
    private static OCType getExpectedTypeRanked(@Nullable Collection<OCType> expectedTypes) {
        if (expectedTypes == null || expectedTypes.isEmpty()) {
            return OCUnknownType.INSTANCE;
        }
        if (expectedTypes.size() == 1) {
            return expectedTypes.iterator().next();
        }
        ArrayList<OCType> rankedExpectedTypes = new ArrayList<OCType>(expectedTypes);
        Collections.sort(rankedExpectedTypes, OCExpectedTypeUtil.getTypeRankComparator());
        return rankedExpectedTypes.iterator().next();
    }

    @NotNull
    private static Comparator<OCType> getTypeRankComparator() {
        HashMap<Class, Integer> typesRank = new HashMap<Class, Integer>();
        typesRank.put(OCIntType.class, 1);
        typesRank.put(OCRealType.class, 2);
        typesRank.put(OCCppReferenceType.class, 3);
        typesRank.put(OCEllipsisType.class, Integer.MAX_VALUE);
        int defaultRank = 0x7FFFFFFE;
        return (o1, o2) -> {
            Integer o1Rank = typesRank.getOrDefault(o1.getClass(), defaultRank);
            Integer o2Rank = typesRank.getOrDefault(o2.getClass(), defaultRank);
            return o1Rank.compareTo(o2Rank);
        };
    }

    private static final class MyParentVisitor
    extends OCVisitor {
        private final OCExpression myExpr;
        private final boolean myConvertLiteralTypes;
        private final OCResolveContext myContext;
        private final Set<OCType> myResult;
        private final List<OCType> myTypesList = new ArrayList<OCType>();

        private MyParentVisitor(OCExpression expr, boolean convertLiteralTypes, @NotNull OCResolveContext context) {
            this.myExpr = expr;
            this.myConvertLiteralTypes = convertLiteralTypes;
            this.myContext = context;
            this.myResult = OCTypeUtils.newTypeSet();
        }

        private void addType(@NotNull OCType type) {
            if (type != OCUnknownType.INSTANCE && this.myResult.add(type)) {
                this.myTypesList.add(type);
            }
        }

        private void addTypes(@NotNull Collection<OCType> types) {
            for (OCType type : types) {
                this.addType(type);
            }
        }

        @Override
        public void visitMessageArgument(OCMessageArgument argument) {
            OCSendMessageExpression call = (OCSendMessageExpression)argument.getParent();
            int paramIndex = call.getArguments().indexOf(argument);
            for (OCMethodSymbol responder : call.getProbableResponders().getAllResponders()) {
                List<OCMethodSymbol.SelectorPartSymbol> selectors = responder.getSelectors();
                if (paramIndex < selectors.size()) {
                    OCDeclaratorSymbol parameter = selectors.get(paramIndex).getParameter();
                    if (parameter == null) continue;
                    this.addType(parameter.getType());
                    continue;
                }
                OCType formatType = OCFormatSpecifiersUtil.getFormatArgumentType(responder, paramIndex, call.getArgumentExpressions());
                if (formatType == null) continue;
                this.addType(formatType);
            }
        }

        @Override
        public void visitArgumentList(OCArgumentList argList) {
            PsiElement parent = argList.getParent();
            if (parent instanceof OCCallExpression) {
                OCCallExpression call = (OCCallExpression)parent;
                OCExpression function = call.getFunctionReferenceExpression();
                if (function instanceof OCReferenceExpression) {
                    OCReferenceElement element = ((OCReferenceExpression)function).getReferenceElement();
                    if (element != null) {
                        Collection<OCSymbol> overloads = element.resolveToOverloadsSymbols();
                        for (OCSymbol symbol : overloads) {
                            OCType type = symbol.getType();
                            if (!(type instanceof OCFunctionType)) continue;
                            this.findParamType(call, (OCFunctionType)type, call.getArguments());
                        }
                    }
                } else {
                    OCType funType = function.getResolvedType(this.myContext);
                    if (funType instanceof OCReferenceType) {
                        funType = funType.resolve(this.myContext);
                    }
                    if (funType instanceof OCPointerType) {
                        funType = ((OCPointerType)funType).getRefType();
                    }
                    if (funType instanceof OCFunctionType) {
                        this.findParamType(call, (OCFunctionType)funType, call.getArguments());
                    }
                }
            } else {
                OCSymbol symbol = null;
                List<OCExpression> arguments = null;
                if (parent instanceof OCConstructorFieldInitializer) {
                    OCConstructorFieldInitializer initializer = (OCConstructorFieldInitializer)parent;
                    OCReferenceElement refElement = initializer.getReferenceElement();
                    symbol = refElement != null ? refElement.resolveToSymbol(this.myContext) : null;
                    arguments = initializer.getArguments();
                } else if (parent instanceof OCDeclarator) {
                    PsiReference constructorReference = parent.getReference();
                    symbol = constructorReference instanceof OCReference ? ((OCReference)constructorReference).resolveToSymbol() : null;
                    OCArgumentList argumentList = ((OCDeclarator)parent).getArgumentList();
                    List<OCExpression> list = arguments = argumentList != null ? argumentList.getArguments() : null;
                    if (symbol == null && arguments != null && arguments.size() == 1) {
                        this.addType(((OCDeclarator)parent).getType());
                    }
                } else if (parent instanceof OCCppNewExpression) {
                    OCReferenceElement refElement = ((OCCppNewExpression)parent).getReferenceElement();
                    symbol = refElement != null ? refElement.resolveToSymbol(this.myContext) : null;
                    arguments = ((OCCppNewExpression)parent).getArguments();
                }
                if (symbol != null && this.myExpr instanceof OCCompoundInitializer && symbol.getKind().isConstructorOrDestructor()) {
                    this.addType(symbol.getEffectiveResolvedType(this.myContext));
                }
                if (symbol instanceof OCFunctionGroupSymbol) {
                    symbol = (OCSymbol)ContainerUtil.getFirstItem(((OCFunctionGroupSymbol)symbol).getOverloads());
                }
                if (symbol instanceof OCFunctionSymbol && arguments != null) {
                    this.findParamType(null, (OCFunctionType)symbol.getType(), arguments);
                } else if (symbol instanceof OCDeclaratorSymbol) {
                    this.addType(symbol.getType());
                } else if (symbol instanceof OCStructSymbol) {
                    this.addType(new OCStructType((OCStructSymbol)symbol));
                }
            }
        }

        private void findParamType(@Nullable OCCallExpression call, OCFunctionType funType, List<OCExpression> arguments) {
            int idx = 0;
            for (OCExpression arg : arguments) {
                if (arg == this.myExpr) break;
                ++idx;
            }
            List<OCType> argTypes = funType.getParameterTypes();
            if (idx < argTypes.size() && !(argTypes.get(idx) instanceof OCEllipsisType)) {
                this.addType(argTypes.get(idx));
            } else if (call != null) {
                OCType formatType;
                OCSymbol symbol = OCGetSymbolVisitor.getSymbol(call.getFunctionReferenceExpression(), this.myContext);
                OCType oCType = formatType = symbol != null ? OCFormatSpecifiersUtil.getFormatArgumentType(symbol, idx, arguments) : null;
                if (formatType != null) {
                    this.addType(formatType);
                }
            }
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression) {
            OCExpression sourceExpression = expression.getSourceExpression();
            OCExpression receiverExpression = expression.getReceiverExpression();
            if (this.myExpr == sourceExpression) {
                this.addType(OCExpectedTypeUtil.getExpressionType(receiverExpression, this.myConvertLiteralTypes));
            } else if (this.myExpr == receiverExpression && sourceExpression != null) {
                this.addType(OCExpectedTypeUtil.getExpressionType(sourceExpression, this.myConvertLiteralTypes));
            }
        }

        @Override
        public void visitReturnStatement(OCReturnStatement stmt) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCCallable.class});
            if (callable != null) {
                this.addType(callable.getReturnType());
            }
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            if (this.myExpr instanceof OCCompoundInitializer || this.myExpr == declarator.getInitializer()) {
                this.addType(declarator.getType());
            }
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            OCElementType sign;
            PsiReference ref = expression.getReference();
            if (ref instanceof OCOperatorReference) {
                List<OCSymbol> overloads = ((OCOperatorReference)ref).resolveToSymbols(false, this.myContext);
                int index = this.myExpr == expression.getLeft() ? 0 : 1;
                for (OCSymbol symbol : overloads) {
                    OCType type = symbol.getType();
                    if (!(type instanceof OCFunctionType)) continue;
                    List<OCType> types = ((OCFunctionType)type).getParameterTypes();
                    Project project = expression.getProject();
                    if (types.size() > 1) {
                        this.addType(types.get(index).resolve(OCResolveContext.forSymbol(symbol, project)).getGuessedType());
                        continue;
                    }
                    if (types.isEmpty() || index != 1) continue;
                    this.addType(types.get(0).resolve(OCResolveContext.forSymbol(symbol, project)).getGuessedType());
                }
            }
            if ((sign = expression.getOperationSign()) == OCTokenTypes.OR || sign == OCTokenTypes.AND) {
                this.addTypes(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext));
            } else {
                OCExpression left = expression.getLeft();
                if (this.myExpr == left) {
                    OCExpression right = expression.getRight();
                    if (right != null) {
                        this.addType(OCExpectedTypeUtil.getExpressionType(right, this.myConvertLiteralTypes));
                    }
                } else if (this.myExpr == expression.getRight() && left != null) {
                    this.addType(OCExpectedTypeUtil.getExpressionType(left, this.myConvertLiteralTypes));
                }
                if (this.myResult.isEmpty()) {
                    this.addTypes(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext));
                }
                if (this.myResult.isEmpty() && OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)sign)) {
                    this.addType(OCIntType.INT);
                }
            }
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression) {
            OCElementType sign = expression.getOperationSign();
            this.addTypes(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext));
            if (this.myResult.isEmpty() && OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)sign)) {
                this.addType(OCIntType.INT);
            }
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression) {
            OCElementType sign = expression.getOperationSign();
            this.addTypes(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext));
            if (this.myResult.isEmpty() && OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)sign)) {
                this.addType(OCIntType.INT);
            }
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            PsiReference ref = expression.getReference();
            if (ref instanceof OCOperatorReference) {
                Collection<OCSymbol> overloads = ((OCOperatorReference)ref).resolveToSymbols(false);
                for (OCSymbol symbol : overloads) {
                    List<OCType> types;
                    OCType type = symbol.getType();
                    if (!(type instanceof OCFunctionType) || (types = ((OCFunctionType)type).getParameterTypes()).size() <= 0) continue;
                    this.addType(types.get(0).resolve(OCResolveContext.forSymbol(symbol, expression.getProject())).getGuessedType());
                }
            }
            if (expression.getOperationSign() == OCTokenTypes.EXCL) {
                this.addType(OCIntType.getAppropriateBool(expression));
            } else if (expression.isGetAddress()) {
                this.addTypes(ContainerUtil.mapNotNull(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext), parentType -> parentType instanceof OCPointerType ? ((OCPointerType)parentType).getRefType() : null));
            } else if (expression.getOperationSign() == OCTokenTypes.MUL) {
                this.addTypes(ContainerUtil.mapNotNull(OCExpectedTypeUtil.getExpectedTypes(expression, this.myConvertLiteralTypes, this.myContext), parentType -> !parentType.isUnknown() ? OCPointerType.to(parentType) : null));
            }
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            if (this.myExpr == expression.getCondition()) {
                this.addType(OCIntType.getAppropriateBool(expression));
            } else {
                OCExpression negativeExpression = expression.getNegativeExpression();
                OCExpression positiveExpression = expression.getPositiveExpression(true);
                if (this.myExpr == negativeExpression && positiveExpression != null) {
                    this.addType(OCExpectedTypeUtil.getExpressionType(positiveExpression, this.myConvertLiteralTypes));
                } else if (this.myExpr == positiveExpression && negativeExpression != null) {
                    this.addType(OCExpectedTypeUtil.getExpressionType(negativeExpression, this.myConvertLiteralTypes));
                }
            }
            if (this.myResult.isEmpty()) {
                this.addType(OCExpectedTypeUtil.getExpectedType(expression, this.myConvertLiteralTypes, this.myContext));
            }
        }

        @Override
        public void visitCondition(OCCondition declOrExpr) {
            PsiElement parent;
            if (this.myExpr == declOrExpr.getExpression() && ((parent = declOrExpr.getParent()) instanceof OCIfStatement || parent instanceof OCForStatement || parent instanceof OCWhileStatement)) {
                this.addType(OCIntType.getAppropriateBool(declOrExpr));
            }
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement stmt) {
            if (this.myExpr == stmt.getCondition()) {
                this.addType(OCIntType.getAppropriateBool(stmt));
            }
        }

        @Override
        public void visitForeachStatement(OCForeachStatement stmt) {
            if (this.myExpr == stmt.getCollectionExpression() && !stmt.isCpp11Foreach()) {
                this.addType(OCReferenceType.resolvedFromText("id", "NSFastEnumeration", stmt));
            }
        }

        @Override
        public void visitCaseStatement(OCCaseStatement stmt) {
            if (this.myExpr == stmt.getExpression()) {
                OCCondition subject;
                OCSwitchStatement switchStatement = (OCSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCSwitchStatement.class);
                OCCondition oCCondition = subject = switchStatement != null ? switchStatement.getExpression() : null;
                if (subject != null) {
                    this.addType(subject.getResolvedType());
                }
            }
        }

        @Override
        public void visitCastExpression(OCCastExpression expression) {
            if (this.myExpr instanceof OCCompoundInitializer) {
                this.addType(expression.getCastType());
            } else {
                expression.getParent().accept((PsiElementVisitor)this);
            }
        }

        @Override
        public void visitConstructorFieldInitializer(OCConstructorFieldInitializer initializer) {
            if (this.myExpr instanceof OCCompoundInitializer) {
                OCSymbol symbol;
                OCReferenceElement refElement = initializer.getReferenceElement();
                OCSymbol oCSymbol = symbol = refElement != null ? refElement.resolveToSymbol() : null;
                if (symbol != null) {
                    this.addType(symbol.getEffectiveResolvedType(this.myContext));
                }
            }
        }

        @Override
        public void visitTypeElement(OCTypeElement typeElement) {
            if (this.myExpr instanceof OCCompoundInitializer && typeElement.getParent() instanceof OCCppNewExpression) {
                OCCppNewExpression newExpression = (OCCppNewExpression)typeElement.getParent();
                OCType rt = newExpression.getConstructingType().resolve(this.myExpr);
                this.addType(rt);
            }
        }

        @Override
        public void visitDesignatedInitializer(OCDesignatedInitializer initializer) {
            if (this.myExpr instanceof OCCompoundInitializer) {
                OCType parentType;
                OCQualifiedDesignator designation = initializer.getDesignation();
                OCSymbol symbol = designation.resolveToSymbol();
                if (symbol instanceof OCDeclaratorSymbol) {
                    this.addType(symbol.getType());
                } else if (symbol == null && (parentType = designation.getParentType()) instanceof OCArrayType) {
                    this.addType(parentType.getArrayElementType());
                }
            }
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            OCType type;
            if (this.myExpr instanceof OCCompoundInitializer && (type = initializer.inferChildType(this.myExpr)) != null) {
                this.addType(type);
            }
        }

        @Override
        public void visitArrayLiteral(OCNSArrayLiteral literal) {
            this.addType(OCIdType.pointerToID());
        }

        @Override
        public void visitDictionaryLiteral(OCNSDictionaryLiteral literal) {
            this.addType(OCIdType.pointerToID());
        }
    }

    public static interface Expectable {
        public OCType getExpectedType();
    }
}

