/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCExplicitSpecifier;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDocUtil {
    private static final EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static final EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEXPR);
    private static final String[] structTypes = new String[]{"struct", "class", "union", "enum"};
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = symbol -> StringUtil.escapeXmlEntities((String)symbol.getPresentableName());

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param) {
        return OCDocUtil.parameterSignature(type, param, null);
    }

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param, @Nullable String defValue) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param) && !param.isEmpty();
        sb.append(type);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        return sb.toString();
    }

    @NlsSafe
    @NotNull
    public static String delimiter(@NotNull String type) {
        return OCDocUtil.delimiter(type, " ");
    }

    @NlsSafe
    @NotNull
    public static String delimiter(@NotNull String type, @NotNull String del) {
        if (!(type.endsWith("*") || type.endsWith("&") || type.endsWith("&amp;"))) {
            return del;
        }
        return "";
    }

    private static void appendExplicitSpecifier(@NotNull OCFunctionDeclaration functionDeclaration, @NotNull HtmlBuilder sb) {
        OCCondition explicitCond;
        OCExplicitSpecifier explicitSpecifier = functionDeclaration.getExplicitSpecifier();
        if (explicitSpecifier != null && (explicitCond = explicitSpecifier.getCondition()) != null) {
            sb.append("(").append(explicitCond.getTextWithMacros()).append(")");
        }
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull HtmlBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append(attr.toString()).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @Nullable OCFunctionDeclaration functionDeclaration, HtmlBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append(attr.toString());
            if (attr == OCSymbolAttribute.EXPLICIT && functionDeclaration != null) {
                OCDocUtil.appendExplicitSpecifier(functionDeclaration, sb);
            }
            sb.append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull HtmlBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append(attr.toString()).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCLexerTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull HtmlBuilder sb) {
        if (symbol.isConst()) {
            sb.append(" ").append(OCLexerTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append(attr.toString());
        }
    }

    @NotNull
    @NlsSafe
    public static String getParametersSignatureHtml(@NotNull OCFunctionSymbol symbol, boolean useSubstitution, @NotNull OCResolveContext context) {
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingPsiFile(context.getProject())));
                typeText = OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context);
            } else {
                typeText = param.getType().getCanonicalName(context);
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                OCInitializerSymbol init = Objects.requireNonNull(param.getInitializer());
                answer.append(" = ").append(init.getSignature(context.getProject()));
            }
            isFirst = false;
        }
        return answer.append(')').toString();
    }

    @NotNull
    public static String getCanonicalNameHtml(@NotNull OCType type, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context) {
        OCType ptrType;
        CVQualifiers qualifiers;
        OCType referenceType;
        OCType terminalType = type.getTerminalType();
        OCType resolvedType = terminalType.resolve(context);
        if (!(resolvedType instanceof OCStructType)) {
            return StringUtil.escapeXmlEntities((String)type.getCanonicalName(context));
        }
        OCQualifiedName originalName = terminalType instanceof OCReferenceType ? ((OCReferenceType)terminalType).getReference().getQualifiedName() : null;
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context.getElement(), (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        OCResolveContext fileContext = OCResolveContext.forPsi((PsiElement)context.getFile());
        String name = OCDocUtil.replaceAnonymousInQualifiedName(new OCTypeNameVisitor(OCType.Presentation.BEST, false, true, fileContext, 0).getName(resolvedType.resolve(fileContext)));
        OCType oCType = referenceType = parent == null ? null : OCElementFactory.typeElementFromText(name, (PsiElement)parent).getType();
        if (!(referenceType instanceof OCReferenceType)) {
            return StringUtil.escapeXmlEntities((String)type.getCanonicalName(context));
        }
        StringBuilder res = new StringBuilder();
        OCQualifiedName qualifiedName = ((OCReferenceType)referenceType).getReference().getQualifiedName();
        if (originalName != null && OCElementUtil.getQualifiedNameComplexity(originalName, 0, 1) > OCElementUtil.getQualifiedNameComplexity(qualifiedName, 0, 1)) {
            qualifiedName = originalName;
        }
        OCQualifiedName droppedPrefix = null;
        OCQualifiedName suffix = qualifiedName;
        for (OCSymbolWithQualifiedName ns : contextNamespace) {
            String qualifier = suffix.getLeftmostQualifier();
            if (qualifier == null || !qualifier.equals(ns.getName())) continue;
            droppedPrefix = OCQualifiedName.with(droppedPrefix, qualifier);
            suffix = suffix.dropSuperQualifier();
        }
        while (qualifiedName != null && !qualifiedName.equals(droppedPrefix)) {
            OCSymbol struct;
            HtmlBuilder part = new HtmlBuilder();
            List<OCSymbol> symbols = OCSymbolReference.getLocalReference(qualifiedName, context.getElement(), new OCSymbolReference.TrueSymbolFilter()).resolveToSymbols(context);
            if (symbols.isEmpty()) {
                symbols = OCSymbolReference.getLocalReference(qualifiedName.dropArguments(), context.getElement(), new OCSymbolReference.TrueSymbolFilter()).resolveToSymbols(context);
            }
            if ((struct = (OCSymbol)ContainerUtil.find(symbols, s -> s instanceof OCStructSymbol)) != null) {
                part.append(OCDocUtil.wrapSymbolName(struct));
            } else {
                if (!symbols.isEmpty() && symbols.get(0) instanceof OCFunctionSymbol) break;
                part.append(StringUtil.notNullize((String)qualifiedName.getName()));
            }
            if (qualifiedName instanceof OCQualifiedNameWithArguments) {
                OCDocUtil.wrapTemplateArgs(((OCQualifiedNameWithArguments)qualifiedName).getArguments(), contextNamespace, context, part);
            }
            if (res.length() > 0) {
                part.append("::");
            }
            res.insert(0, part);
            qualifiedName = qualifiedName.getQualifier();
        }
        CVQualifiers cVQualifiers = qualifiers = type instanceof OCCppReferenceType || type instanceof OCPointerType ? type.getTerminalType().getCVQualifiers() : type.getCVQualifiers();
        if (qualifiers.isVolatile()) {
            res.insert(0, OCLexerTokenTypes.VOLATILE_KEYWORD.getName() + " ");
        }
        if (qualifiers.isConst()) {
            res.insert(0, OCLexerTokenTypes.CONST_KEYWORD.getName() + " ");
        }
        if (type instanceof OCCppReferenceType) {
            OCCppReferenceType refType = (OCCppReferenceType)type;
            if (refType.isRvalueRef()) {
                res.append(" &amp;&amp;");
            } else {
                res.append(" &amp;");
            }
        }
        if ((ptrType = type) instanceof OCPointerType) {
            res.append(" ");
        }
        while (ptrType instanceof OCPointerType) {
            res.append("*");
            ptrType = ((OCPointerType)ptrType).getRefType();
        }
        return res.toString();
    }

    @NotNull
    @NlsSafe
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        return StringUtil.join(OCDocUtil.getParents(symbol, context), TO_NAME, (String)"::");
    }

    @NotNull
    public static String getCanonicalPrefixHtml(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, context);
        List structParents = ContainerUtil.filter(chain, s -> s.getKind().isStructLike());
        List namespace = ContainerUtil.filter(chain, s -> s.getKind() == OCSymbolKind.NAMESPACE);
        if (!structParents.isEmpty()) {
            OCSymbolWithQualifiedName parent = (OCSymbolWithQualifiedName)structParents.get(structParents.size() - 1);
            String prefix = OCDocUtil.getCanonicalNameHtml(parent.getType(), namespace, context);
            return OCDocUtil.replaceAnonymous(prefix);
        }
        return "";
    }

    @NotNull
    @NlsSafe
    public static String replaceAnonymous(@NlsSafe @NotNull String canonicalName) {
        canonicalName = canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
        for (String type : structTypes) {
            canonicalName = canonicalName.replace(type + " null", "<i>(anonymous)</i>" + type).replace(type + "__anonymous", "<i>(anonymous)</i>" + type);
        }
        return canonicalName;
    }

    @NotNull
    public static String replaceAnonymousInQualifiedName(@NotNull String canonicalName) {
        for (String type : structTypes) {
            canonicalName = canonicalName.replace("anonymous " + type, type + "__anonymous");
        }
        return canonicalName;
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(context, symbol, OCSymbolKind.NAMESPACE);
        chain.remove(symbol);
        return chain;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCResolveContext context, @NotNull OCSymbolWithQualifiedName symbol, OCSymbolKind ... filter) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, symbol.getDefaultArgumentsRemovalStrategy(), false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> {
            for (OCSymbolKind kind : filter) {
                if (parent.getKind() != kind) continue;
                parents.add((OCSymbolWithQualifiedName)parent);
            }
        }));
        return parents;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, symbol.getDefaultArgumentsRemovalStrategy(), false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parents::add));
        parents.remove(symbol);
        return parents;
    }

    @NotNull
    private static HtmlBuilder wrapSymbolName(@NotNull OCSymbol symbol) {
        HtmlBuilder sb = new HtmlBuilder();
        if (!(symbol instanceof OCStructSymbol)) {
            sb.append(HtmlChunk.text((String)symbol.getPresentableName()));
        } else {
            OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        }
        return sb;
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull HtmlBuilder sb) {
        String name = symbol.getName();
        boolean hasName = !"<unnamed>".equals(name);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append((HtmlChunk)HtmlChunk.link((String)link, (String)name));
        } else {
            sb.append(symbol.getPresentableName());
        }
    }

    @NotNull
    public static String getLinkHtml(@NotNull OCSymbol symbol) {
        String name = symbol.getPresentableName();
        boolean hasName = !"<unnamed>".equals(name);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            return "<a href=\"" + link + "\">" + StringUtil.escapeXmlEntities((String)name) + "</a>";
        }
        return StringUtil.escapeXmlEntities((String)symbol.getPresentableName());
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context, @NotNull HtmlBuilder answer) {
        String templateArgumentsStr = StringUtil.join(templateArguments, templateArgument -> {
            if (templateArgument instanceof OCType) {
                return OCDocUtil.getCanonicalNameHtml((OCType)templateArgument, contextNamespace, context);
            }
            if (templateArgument instanceof OCExpressionTypeArgument) {
                return ((OCExpressionTypeArgument)templateArgument).getSymbol().getPresentableName();
            }
            return "";
        }, (String)", ");
        if (!templateArgumentsStr.isEmpty()) {
            answer.append("<").appendRaw(templateArgumentsStr).append(">");
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context, @NotNull HtmlBuilder answer) {
        String templateParamsStr = StringUtil.join(templateParams, param -> {
            StringBuilder sb = new StringBuilder();
            if (param instanceof OCTypeParameterValueSymbol) {
                String type = param.getType().getName();
                sb.append(type).append(OCDocUtil.delimiter(type));
            }
            if (param.isVariadic()) {
                sb.append("...");
            }
            sb.append(param.getName());
            Object value = param.getDefaultValue();
            if (value != null) {
                sb.append(" = ");
                if (value instanceof OCType) {
                    sb.append(OCDocUtil.getCanonicalNameHtml((OCType)value, contextNamespace, context));
                } else if (value instanceof OCExpressionTypeArgument) {
                    sb.append(((OCExpressionTypeArgument)value).getSymbol().getPresentableName());
                }
            }
            return sb.toString();
        }, (String)", ");
        answer.append("template<").appendRaw(templateParamsStr).append(">");
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(file.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithParent> getSuperSymbols(@NotNull PsiElement element) {
        Object symbol;
        ArrayList<OCSymbolWithParent> supers = new ArrayList<OCSymbolWithParent>();
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCSymbolWithParent) {
            OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)((Processor)s -> {
                supers.add((OCSymbolWithParent)s);
                return true;
            }), true, element.getProject());
        }
        return supers;
    }
}

